/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr168.ext.session;

import java.io.IOException;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.UTP1;

@TestCase(value={Assertion.EXT_SESSION_2})
public class HTTPSessionInvalidationInvalidesPortletSession {
    public HTTPSessionInvalidationInvalidesPortletSession(PortletTestCase seq) {
        seq.bindAction(0, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                PortletSession session = request.getPortletSession();
                SessionInvalidator invalidator = new SessionInvalidator();
                invalidator.invalidate(session);
                session = request.getPortletSession(false);
                Assert.assertNull((Object)session);
                return new EndTestResponse();
            }
        });
    }

    private static class SessionInvalidator
    implements HttpSessionBindingListener {
        private HttpSession realSession;

        private SessionInvalidator() {
        }

        public void valueBound(HttpSessionBindingEvent event) {
            this.realSession = event.getSession();
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
        }

        public void invalidate(PortletSession session) {
            session.setAttribute("foo", (Object)this);
            this.realSession.invalidate();
        }
    }
}

