/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr168.tck.portletmode.spec;

import java.io.IOException;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Failure;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.annotations.TestActor;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.FailureResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.AbstractTestGenericPortlet;

@TestActor(id="RequestDispatchingDependingOnModePortlet")
public class RequestDispatchingDependingOnModePortlet
extends AbstractTestGenericPortlet {
    public static final String NAME = "RequestDispatchingDependingOnModePortlet";
    private String methodCall;
    private PortletTestContext context;

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (this.context.getRequestCount() == 1) {
            this.methodCall = "doView";
        }
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (this.context.getRequestCount() == 2) {
            this.methodCall = "doEdit";
        }
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (this.context.getRequestCount() == 3) {
            this.methodCall = "doHelp";
        }
    }

    protected void preRender(RenderRequest req, RenderResponse resp, PortletTestContext context) throws PortletException, IOException {
        this.context = context;
        this.methodCall = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response postRender(RenderRequest req, RenderResponse resp, PortletTestContext context) throws PortletException, IOException {
        try {
            switch (context.getRequestCount()) {
                case 0: {
                    PortletURL url = resp.createRenderURL();
                    url.setPortletMode(PortletMode.VIEW);
                    InvokeGetResponse invokeGetResponse = new InvokeGetResponse(url.toString());
                    return invokeGetResponse;
                }
                case 1: {
                    Assert.assertEquals((Object)"doView", (Object)this.methodCall);
                    PortletURL url = resp.createRenderURL();
                    url.setPortletMode(PortletMode.EDIT);
                    InvokeGetResponse invokeGetResponse = new InvokeGetResponse(url.toString());
                    return invokeGetResponse;
                }
                case 2: {
                    Assert.assertEquals((Object)"doEdit", (Object)this.methodCall);
                    PortletURL url = resp.createRenderURL();
                    url.setPortletMode(PortletMode.HELP);
                    InvokeGetResponse invokeGetResponse = new InvokeGetResponse(url.toString());
                    return invokeGetResponse;
                }
                case 3: {
                    Assert.assertEquals((Object)"doHelp", (Object)this.methodCall);
                    EndTestResponse endTestResponse = new EndTestResponse();
                    return endTestResponse;
                }
            }
            FailureResponse failureResponse = new FailureResponse(Failure.createAssertionFailure((String)""));
            return failureResponse;
        }
        finally {
            this.context = null;
            this.methodCall = null;
        }
    }
}

