/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr168.tck.portletsession;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class HttpSessionEvents
implements HttpSessionListener {
    public static final ThreadLocal threadLocal = new ThreadLocal();

    public void sessionCreated(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        List sessions = HttpSessionEvents.getEvents();
        if (sessions != null) {
            String id = session.getId();
            sessions.add(new Event(id, 0));
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        List sessions = HttpSessionEvents.getEvents();
        if (sessions != null) {
            String id = session.getId();
            sessions.add(new Event(id, 1));
        }
    }

    public static List getEvents() {
        return (List)threadLocal.get();
    }

    public static void activate() {
        if (threadLocal.get() != null) {
            throw new IllegalStateException("Already activated");
        }
        ArrayList sessions = new ArrayList();
        threadLocal.set(sessions);
    }

    public static void desactivate() {
        threadLocal.set(null);
    }

    public static class Event {
        public static final int CREATED = 0;
        public static final int DESTROYED = 1;
        private final String sessionId;
        private final int type;

        public Event(String sessionId, int type) {
            this.sessionId = sessionId;
            this.type = type;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public int getType() {
            return this.type;
        }
    }
}

