/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr168.tck.portletsession;

import java.io.IOException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletActionTestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.actions.ServletServiceTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.UTP1;
import org.gatein.pc.test.unit.web.UTP2;
import org.gatein.pc.test.unit.web.UTS1;

@TestCase(value={Assertion.JSR168_110, Assertion.JSR168_111, Assertion.JSR168_112, Assertion.JSR168_117, Assertion.JSR168_118, Assertion.JSR168_119})
public class SessionAttributes {
    public SessionAttributes(PortletTestCase seq) {
        seq.bindAction(0, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                request.getPortletSession(true).setAttribute("key1", (Object)"k1value1", 1);
                request.getPortletSession().setAttribute("key2", (Object)"k2value1", 2);
                PortletURL url = response.createActionURL();
                return new InvokeGetResponse(url.toString());
            }
        });
        seq.bindAction(1, UTP1.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) {
                Assert.assertEquals((Object)"k1value1", (Object)request.getPortletSession().getAttribute("key1", 1));
                Assert.assertEquals((Object)"k2value1", (Object)request.getPortletSession().getAttribute("key2"));
            }
        });
        seq.bindAction(1, UTP2.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                Assert.assertEquals((Object)"k1value1", (Object)request.getPortletSession().getAttribute("key1", 1));
                Assert.assertNull((Object)request.getPortletSession().getAttribute("key2"));
                return null;
            }
        });
        seq.bindAction(1, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                PortletURL url = response.createRenderURL();
                return new InvokeGetResponse(url.toString());
            }
        });
        seq.bindAction(2, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                String path = request.getContextPath();
                return new InvokeGetResponse(path + "/universalServletA");
            }
        });
        seq.bindAction(3, UTS1.SERVICE_JOIN_POINT, (TestAction)new ServletServiceTestAction(){

            protected Response run(Servlet servlet, HttpServletRequest request, HttpServletResponse response, PortletTestContext context) throws ServletException, IOException {
                Assert.assertEquals((Object)"k1value1", (Object)request.getSession().getAttribute("key1"));
                Assert.assertNull((Object)request.getSession().getAttribute("key2"));
                Enumeration names = request.getSession().getAttributeNames();
                String name = null;
                while (names.hasMoreElements()) {
                    String s = (String)names.nextElement();
                    if (!s.endsWith("key2")) continue;
                    name = s;
                    break;
                }
                Assert.assertNotNull(name);
                Assert.assertEquals((Object)"k2value1", (Object)request.getSession().getAttribute(name));
                System.out.println("value: " + name);
                Assert.assertTrue((boolean)Pattern.matches("javax.portlet.p.[^\\?]*\\?key2", name));
                return new EndTestResponse();
            }
        });
    }
}

