/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.api.portleturl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.UTP1;

@TestCase(value={Assertion.API286_BASE_URL_5})
public class EscapeXML {
    public EscapeXML(PortletTestCase seq) {
        seq.bindAction(0, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                response.setContentType("text/html");
                PrintWriter writer = response.getWriter();
                PortletURL url = response.createRenderURL();
                url.setParameter("foo", "bar");
                ((Writer)writer).write("@BEFORE_ESCAPED@");
                url.write((Writer)writer, true);
                ((Writer)writer).write("@AFTER_ESCAPED@");
                ((Writer)writer).write("@BEFORE_NON_ESCAPED@");
                url.write((Writer)writer, false);
                ((Writer)writer).write("@AFTER_NON_ESCAPED@");
                return new InvokeGetResponse(response.createRenderURL().toString());
            }
        });
        seq.bindAction(1, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                byte[] content = context.getResponseBody();
                String text = new String(content, "UTF-8");
                String escapedURL = EscapeXML.this.getURL(text, "ESCAPED");
                int pos = escapedURL.indexOf(38);
                while (pos != -1) {
                    String s = escapedURL.substring(pos, pos + "&amp;".length());
                    Assert.assertEquals((Object)"&amp;", (Object)s);
                    pos = escapedURL.indexOf(38, pos + 1);
                }
                String nonEscapedURL = EscapeXML.this.getURL(text, "NON_ESCAPED");
                int pos2 = nonEscapedURL.indexOf(38);
                while (pos2 != -1) {
                    int end = Math.min(pos2 + "&amp;".length(), nonEscapedURL.length());
                    String s = nonEscapedURL.substring(pos2, end);
                    String comparison = "&amp;".substring(0, end - pos2);
                    Assert.assertNotEquals((Object)comparison, (Object)s);
                    pos2 = nonEscapedURL.indexOf(38, pos2 + 1);
                }
                return new EndTestResponse();
            }
        });
    }

    private String getURL(String text, String type) {
        int from = text.indexOf("@BEFORE_" + type + "@");
        Assert.assertNotEquals((Object)-1, (Object)from);
        int to = text.indexOf("@AFTER_" + type + "@");
        Assert.assertNotEquals((Object)-1, (Object)to);
        return text.substring(from + ("@BEFORE_" + type + "@").length(), to);
    }
}

