/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.ext.portletmode;

import java.io.IOException;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gatein.common.util.Tools;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletActionTestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.UTP1;

@TestCase(value={Assertion.EXT_PORTLET_MODE_7})
public class CustomPortletModes {
    private static final PortletMode CUSTOM_PORTAL = new PortletMode("CUSTOM_PORTAL");
    private static final PortletMode CUSTOM_PORTLET = new PortletMode("CUSTOM_PORTLET");
    private static final PortletMode NON_EXISTING = new PortletMode("NON_EXISTING");
    private static final List<PortletMode> legalModes = Tools.toList((Object[])new PortletMode[]{PortletMode.VIEW, PortletMode.HELP, CUSTOM_PORTLET});
    private static final List<PortletMode> illegalModes = Tools.toList((Object[])new PortletMode[]{PortletMode.EDIT, CUSTOM_PORTAL, NON_EXISTING});

    public CustomPortletModes(PortletTestCase seq) {
        seq.bindAction(0, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                Assert.assertEquals((Object)PortletMode.VIEW, (Object)request.getPortletMode());
                CustomPortletModes.this.testRequest((PortletRequest)request, legalModes, illegalModes);
                CustomPortletModes.this.testURL(response.createActionURL(), legalModes, illegalModes);
                CustomPortletModes.this.testURL(response.createRenderURL(), legalModes, illegalModes);
                PortletURL url = response.createActionURL();
                url.setPortletMode(PortletMode.HELP);
                return new InvokeGetResponse(url.toString());
            }
        });
        seq.bindAction(1, UTP1.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws PortletException, IOException {
                Assert.assertEquals((Object)PortletMode.HELP, (Object)request.getPortletMode());
                CustomPortletModes.this.testRequest((PortletRequest)request, legalModes, illegalModes);
                CustomPortletModes.this.testResponse(response, legalModes, illegalModes);
                response.setPortletMode(PortletMode.HELP);
            }
        });
        seq.bindAction(1, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                Assert.assertEquals((Object)PortletMode.HELP, (Object)request.getPortletMode());
                CustomPortletModes.this.testRequest((PortletRequest)request, legalModes, illegalModes);
                CustomPortletModes.this.testURL(response.createActionURL(), legalModes, illegalModes);
                CustomPortletModes.this.testURL(response.createRenderURL(), legalModes, illegalModes);
                PortletURL url = response.createActionURL();
                url.setPortletMode(CUSTOM_PORTLET);
                return new InvokeGetResponse(url.toString());
            }
        });
        seq.bindAction(2, UTP1.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws PortletException, IOException {
                Assert.assertEquals((Object)CUSTOM_PORTLET, (Object)request.getPortletMode());
                CustomPortletModes.this.testRequest((PortletRequest)request, legalModes, illegalModes);
                CustomPortletModes.this.testResponse(response, legalModes, illegalModes);
                response.setPortletMode(CUSTOM_PORTLET);
            }
        });
        seq.bindAction(2, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                Assert.assertEquals((Object)CUSTOM_PORTLET, (Object)request.getPortletMode());
                CustomPortletModes.this.testRequest((PortletRequest)request, legalModes, illegalModes);
                CustomPortletModes.this.testURL(response.createActionURL(), legalModes, illegalModes);
                CustomPortletModes.this.testURL(response.createRenderURL(), legalModes, illegalModes);
                return new EndTestResponse();
            }
        });
    }

    private void testURL(PortletURL url, List<PortletMode> legalModes, List<PortletMode> illegalModes) {
        for (PortletMode mode : legalModes) {
            try {
                url.setPortletMode(mode);
            }
            catch (PortletModeException expected) {
                Assert.fail((String)"Was not expecting a portlet mode exception");
            }
        }
        for (PortletMode mode : illegalModes) {
            try {
                url.setPortletMode(mode);
                Assert.fail((String)"Was expecting a portlet mode exception");
            }
            catch (PortletModeException expected) {}
        }
    }

    private void testResponse(ActionResponse response, List<PortletMode> legalModes, List<PortletMode> illegalModes) {
        for (PortletMode mode : legalModes) {
            try {
                response.setPortletMode(mode);
            }
            catch (PortletModeException expected) {
                Assert.fail((String)"Was not expecting a portlet mode exception");
            }
        }
        for (PortletMode mode : illegalModes) {
            try {
                response.setPortletMode(mode);
                Assert.fail((String)"Was expecting a portlet mode exception");
            }
            catch (PortletModeException expected) {}
        }
    }

    private void testRequest(PortletRequest url, List<PortletMode> legalModes, List<PortletMode> illegalModes) {
        for (PortletMode mode : legalModes) {
            Assert.assertTrue((boolean)url.isPortletModeAllowed(mode));
        }
        for (PortletMode mode : illegalModes) {
            Assert.assertFalse((boolean)url.isPortletModeAllowed(mode));
        }
    }
}

