/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.tck.dispatcher;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletActionTestAction;
import org.gatein.pc.test.unit.actions.PortletEventTestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.actions.PortletResourceTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.UTP1;

@TestCase(value={Assertion.JSR168_121, Assertion.JSR168_122})
public class ObtainingDispatcher {
    public ObtainingDispatcher(PortletTestCase seq) {
        seq.bindAction(0, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                ObtainingDispatcher.check(portlet);
                return new InvokeGetResponse(response.createActionURL().toString());
            }
        });
        seq.bindAction(1, UTP1.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws PortletException, IOException {
                ObtainingDispatcher.check(portlet);
                response.setEvent("Event", null);
            }
        });
        seq.bindAction(1, UTP1.EVENT_JOIN_POINT, (TestAction)new PortletEventTestAction(){

            protected void run(Portlet portlet, EventRequest request, EventResponse response, PortletTestContext context) throws PortletException, IOException {
                ObtainingDispatcher.check(portlet);
            }
        });
        seq.bindAction(1, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                return new InvokeGetResponse(response.createResourceURL().toString());
            }
        });
        seq.bindAction(2, UTP1.RESOURCE_JOIN_POINT, (TestAction)new PortletResourceTestAction(){

            protected Response run(Portlet portlet, ResourceRequest request, ResourceResponse response, PortletTestContext context) throws PortletException, IOException {
                ObtainingDispatcher.check(portlet);
                return new EndTestResponse();
            }
        });
    }

    private static void check(Portlet portlet) {
        UTP1 p = (UTP1)portlet;
        PortletRequestDispatcher dispatcher = p.getPortletContext().getNamedDispatcher("UniversalServletA");
        Assert.assertNotNull((Object)dispatcher);
        dispatcher = p.getPortletContext().getNamedDispatcher("FAKE_NAME_SERVLET");
        Assert.assertNull((Object)dispatcher);
        dispatcher = p.getPortletContext().getNamedDispatcher("/");
        Assert.assertNull((Object)dispatcher);
        dispatcher = p.getPortletContext().getNamedDispatcher("/universalServletA");
        Assert.assertNull((Object)dispatcher);
        dispatcher = p.getPortletContext().getRequestDispatcher("UniversalServletA");
        Assert.assertNull((Object)dispatcher);
        dispatcher = p.getPortletContext().getRequestDispatcher("universalServletA");
        Assert.assertNull((Object)dispatcher);
        dispatcher = p.getPortletContext().getRequestDispatcher("/universalServletA");
        Assert.assertNotNull((Object)dispatcher);
    }
}

