/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.tck.portletrequests;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletActionTestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.UTP1;
import org.gatein.pc.test.unit.web.UTP2;

@TestCase(value={Assertion.JSR286_125})
public class PublicRenderParameter {
    int renderCount = 0;

    public PublicRenderParameter(PortletTestCase seq) {
        seq.bindAction(0, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                return new InvokeGetResponse(response.createActionURL().toString());
            }
        });
        seq.bindAction(1, UTP1.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws PortletException, IOException {
                response.setRenderParameter("foo", "foo");
            }
        });
        seq.bindAction(1, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                String foo = request.getParameter("foo");
                Assert.assertEquals((Object)"foo", (Object)foo);
                ++PublicRenderParameter.this.renderCount;
                PortletURL url = response.createActionURL();
                url.setParameter("foo", "bar");
                return new InvokeGetResponse(url.toString());
            }
        });
        seq.bindAction(1, UTP2.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                String foo = request.getParameter("foo");
                Assert.assertEquals((Object)"foo", (Object)foo);
                ++PublicRenderParameter.this.renderCount;
                return null;
            }
        });
        seq.bindAction(2, UTP1.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws PortletException, IOException {
                Assert.assertEquals((Object)2, (Object)PublicRenderParameter.this.renderCount);
                Object[] strings = (String[])request.getParameterMap().get("foo");
                Assert.assertEquals((Object[])new String[]{"bar", "foo"}, (Object[])strings);
                response.removePublicRenderParameter("foo");
                PublicRenderParameter.this.renderCount = 0;
            }
        });
        seq.bindAction(2, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                String foo = request.getParameter("foo");
                Assert.assertEquals(null, (Object)foo);
                return ++PublicRenderParameter.this.renderCount == 2 ? new EndTestResponse() : null;
            }
        });
        seq.bindAction(2, UTP2.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) {
                String foo = request.getParameter("foo");
                Assert.assertEquals(null, (Object)foo);
                return ++PublicRenderParameter.this.renderCount == 2 ? new EndTestResponse() : null;
            }
        });
    }
}

