/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.url;

import java.util.Arrays;
import junit.framework.TestCase;
import org.gatein.common.util.ParameterMap;
import org.gatein.pc.test.url.CodecBuilder;
import org.gatein.pc.test.url.ParameterEncoder;

public class EncoderTestCase
extends TestCase {
    Tester tester;

    public void setUp() throws Exception {
        this.tester = new Tester();
    }

    private static void assertEquals(String[] expected, String[] actual) {
        EncoderTestCase.assertEquals(Arrays.asList(expected), Arrays.asList(actual));
    }

    public void testEncodeNoMeta() {
        ParameterMap result = this.tester.encode();
        EncoderTestCase.assertEquals((int)1, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0"}, result.getValues("action"));
        this.tester.actual("action", "foo");
        result = this.tester.encode();
        EncoderTestCase.assertEquals((int)1, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0", "foo"}, result.getValues("action"));
        this.tester.meta("action", "foo");
        result = this.tester.encode();
        EncoderTestCase.assertEquals((int)1, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0"}, result.getValues("action"));
    }

    public void testEncodeOneMeta() {
        this.tester.meta("m1");
        ParameterMap result = this.tester.encode();
        EncoderTestCase.assertEquals((int)1, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0"}, result.getValues("action"));
        this.tester.meta("m1", "foo");
        result = this.tester.encode();
        EncoderTestCase.assertEquals((int)2, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"1"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m1"));
        this.tester.actual("m1", "foo");
        result = this.tester.encode();
        EncoderTestCase.assertEquals((int)2, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m1"));
        this.tester.meta("m1", "bar").actual("m1", "foo");
        result = this.tester.encode();
        EncoderTestCase.assertEquals((int)2, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"1"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"bar", "foo"}, result.getValues("m1"));
    }

    public void testEncodeTwoMeta() {
        this.tester.meta("m1");
        this.tester.meta("m2");
        ParameterMap result = this.tester.encode();
        EncoderTestCase.assertEquals((int)1, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0"}, result.getValues("action"));
        result = this.tester.meta("m1", "foo").encode();
        EncoderTestCase.assertEquals((int)2, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"10"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m1"));
        result = this.tester.meta("m2", "foo").encode();
        EncoderTestCase.assertEquals((int)2, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"1"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m2"));
        result = this.tester.meta("m1", "foo").meta("m2", "bar").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"11"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"bar"}, result.getValues("m2"));
        result = this.tester.meta("m1", "foo").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)2, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"10"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m1"));
        result = this.tester.meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)1, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0"}, result.getValues("action"));
        result = this.tester.meta("m2", "foo").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)2, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"1"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m2"));
        result = this.tester.meta("m1", "foo").meta("m2", "bar").meta("m2", "bar").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"11"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"bar"}, result.getValues("m2"));
        result = this.tester.actual("m1", "a").encode();
        EncoderTestCase.assertEquals((int)2, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"a"}, result.getValues("m1"));
        result = this.tester.actual("m1", "a").meta("m1", "foo").encode();
        EncoderTestCase.assertEquals((int)2, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"10"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo", "a"}, result.getValues("m1"));
        result = this.tester.actual("m1", "a").meta("m2", "foo").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"1"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m2"));
        result = this.tester.actual("m1", "a").meta("m1", "foo").meta("m2", "bar").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"11"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo", "a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"bar"}, result.getValues("m2"));
        result = this.tester.actual("m1", "a").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)2, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"a"}, result.getValues("m1"));
        result = this.tester.actual("m1", "a").meta("m1", "foo").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)2, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"10"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo", "a"}, result.getValues("m1"));
        result = this.tester.actual("m1", "a").meta("m2", "foo").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"1"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m2"));
        result = this.tester.actual("m1", "a").meta("m1", "foo").meta("m2", "bar").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"11"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo", "a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"bar"}, result.getValues("m2"));
        result = this.tester.actual("m2", "b").encode();
        EncoderTestCase.assertEquals((int)2, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"b"}, result.getValues("m2"));
        result = this.tester.actual("m2", "b").meta("m1", "foo").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"10"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"b"}, result.getValues("m2"));
        result = this.tester.actual("m2", "b").meta("m2", "foo").encode();
        EncoderTestCase.assertEquals((int)2, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"1"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo", "b"}, result.getValues("m2"));
        result = this.tester.actual("m2", "b").meta("m1", "foo").meta("m2", "bar").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"11"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"bar", "b"}, result.getValues("m2"));
        result = this.tester.actual("m2", "b").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)2, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"b"}, result.getValues("m2"));
        result = this.tester.actual("m2", "b").meta("m1", "foo").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"10"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"b"}, result.getValues("m2"));
        result = this.tester.actual("m2", "b").meta("m2", "foo").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)2, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"1"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo", "b"}, result.getValues("m2"));
        result = this.tester.actual("m2", "b").meta("m1", "foo").meta("m2", "bar").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"11"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"bar", "b"}, result.getValues("m2"));
        result = this.tester.actual("m3", "c").encode();
        EncoderTestCase.assertEquals((int)2, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m3", "c").meta("m1", "foo").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"10"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m3", "c").meta("m2", "foo").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"1"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m3", "c").meta("m1", "foo").meta("m2", "bar").encode();
        EncoderTestCase.assertEquals((int)4, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"11"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"bar"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m3", "c").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)2, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m3", "c").meta("m1", "foo").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"10"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m3", "c").meta("m2", "foo").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"1"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m3", "c").meta("m1", "foo").meta("m2", "bar").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)4, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"11"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"bar"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m1", "a").actual("m2", "b").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"b"}, result.getValues("m2"));
        result = this.tester.actual("m1", "a").actual("m2", "b").meta("m1", "foo").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"10"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo", "a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"b"}, result.getValues("m2"));
        result = this.tester.actual("m1", "a").actual("m2", "b").meta("m2", "foo").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"1"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"foo", "b"}, result.getValues("m2"));
        result = this.tester.actual("m1", "a").actual("m2", "b").meta("m1", "foo").meta("m2", "bar").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"11"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo", "a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"bar", "b"}, result.getValues("m2"));
        result = this.tester.actual("m1", "a").actual("m2", "b").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"b"}, result.getValues("m2"));
        result = this.tester.actual("m1", "a").actual("m2", "b").meta("m1", "foo").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"10"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo", "a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"b"}, result.getValues("m2"));
        result = this.tester.actual("m1", "a").actual("m2", "b").meta("m2", "foo").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"1"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"foo", "b"}, result.getValues("m2"));
        result = this.tester.actual("m1", "a").actual("m2", "b").meta("m1", "foo").meta("m2", "bar").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"11"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo", "a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"bar", "b"}, result.getValues("m2"));
        result = this.tester.actual("m1", "a").actual("m3", "c").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m1", "a").actual("m3", "c").meta("m1", "foo").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"10"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo", "a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m1", "a").actual("m3", "c").meta("m2", "foo").encode();
        EncoderTestCase.assertEquals((int)4, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"1"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m1", "a").actual("m3", "c").meta("m1", "foo").meta("m2", "bar").encode();
        EncoderTestCase.assertEquals((int)4, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"11"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo", "a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"bar"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m1", "a").actual("m3", "c").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m1", "a").actual("m3", "c").meta("m1", "foo").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"10"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo", "a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m1", "a").actual("m3", "c").meta("m2", "foo").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)4, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"1"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m1", "a").actual("m3", "c").meta("m1", "foo").meta("m2", "bar").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)4, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"11"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo", "a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"bar"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m2", "b").actual("m3", "c").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"b"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m2", "b").actual("m3", "c").meta("m1", "foo").encode();
        EncoderTestCase.assertEquals((int)4, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"10"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"b"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m2", "b").actual("m3", "c").meta("m2", "foo").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"1"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo", "b"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m2", "b").actual("m3", "c").meta("m1", "foo").meta("m2", "bar").encode();
        EncoderTestCase.assertEquals((int)4, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"11"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"bar", "b"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m2", "b").actual("m3", "c").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"b"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m2", "b").actual("m3", "c").meta("m1", "foo").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)4, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"10"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"b"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m2", "b").actual("m3", "c").meta("m2", "foo").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)3, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"1"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo", "b"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m2", "b").actual("m3", "c").meta("m1", "foo").meta("m2", "bar").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)4, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"11"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"bar", "b"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m1", "a").actual("m2", "b").actual("m3", "c").encode();
        EncoderTestCase.assertEquals((int)4, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"b"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m1", "a").actual("m2", "b").actual("m3", "c").meta("m1", "foo").encode();
        EncoderTestCase.assertEquals((int)4, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"10"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo", "a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"b"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m1", "a").actual("m2", "b").actual("m3", "c").meta("m2", "foo").encode();
        EncoderTestCase.assertEquals((int)4, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"1"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"foo", "b"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m1", "a").actual("m2", "b").actual("m3", "c").meta("m1", "foo").meta("m2", "bar").encode();
        EncoderTestCase.assertEquals((int)4, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"11"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo", "a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"bar", "b"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m1", "a").actual("m2", "b").actual("m3", "c").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)4, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"0"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"b"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m1", "a").actual("m2", "b").actual("m3", "c").meta("m1", "foo").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)4, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"10"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo", "a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"b"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m1", "a").actual("m2", "b").actual("m3", "c").meta("m2", "foo").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)4, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"1"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"foo", "b"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
        result = this.tester.actual("m1", "a").actual("m2", "b").actual("m3", "c").meta("m1", "foo").meta("m2", "bar").meta("m3", "zuu").encode();
        EncoderTestCase.assertEquals((int)4, (int)result.size());
        EncoderTestCase.assertEquals(new String[]{"11"}, result.getValues("action"));
        EncoderTestCase.assertEquals(new String[]{"foo", "a"}, result.getValues("m1"));
        EncoderTestCase.assertEquals(new String[]{"bar", "b"}, result.getValues("m2"));
        EncoderTestCase.assertEquals(new String[]{"c"}, result.getValues("m3"));
    }

    private static class Tester {
        private CodecBuilder builder = new CodecBuilder("action");
        private ParameterMap actualParameters = new ParameterMap();
        private ParameterMap metaParameters = new ParameterMap();

        private Tester() {
        }

        public Tester meta(String name) {
            this.builder.addMetaParameter(name);
            return this;
        }

        public Tester meta(String name, String value) {
            this.metaParameters.setValue(name, value);
            return this;
        }

        public Tester actual(String name, String value) {
            this.actualParameters.setValue(name, value);
            return this;
        }

        public ParameterMap encode() {
            ParameterEncoder encoder = this.builder.createEncoder();
            encoder.encode(this.actualParameters, this.metaParameters);
            this.actualParameters.clear();
            this.metaParameters.clear();
            return encoder.getParameters();
        }
    }
}

