/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.log;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

final class LogListenerThread
extends Thread {
    private boolean m_stopping = false;
    private final Stack m_entriesToDeliver = new Stack();
    private final List m_listeners = new Vector();

    LogListenerThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEntry(LogEntry entry) {
        Stack stack = this.m_entriesToDeliver;
        synchronized (stack) {
            this.m_entriesToDeliver.add(entry);
            this.m_entriesToDeliver.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(LogListener listener) {
        List list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(LogListener listener) {
        List list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.remove(listener);
        }
    }

    int getListenerCount() {
        return this.m_listeners.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.m_stopping = true;
        Stack stack = this.m_entriesToDeliver;
        synchronized (stack) {
            this.m_entriesToDeliver.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean stop = false;
        while (!stop) {
            Stack stack = this.m_entriesToDeliver;
            synchronized (stack) {
                if (!this.m_entriesToDeliver.isEmpty()) {
                    LogEntry entry = (LogEntry)this.m_entriesToDeliver.pop();
                    List list = this.m_listeners;
                    synchronized (list) {
                        Iterator listenerIt = this.m_listeners.iterator();
                        while (listenerIt.hasNext()) {
                            try {
                                LogListener listener = (LogListener)listenerIt.next();
                                listener.logged(entry);
                            }
                            catch (Throwable t) {}
                        }
                    }
                }
                if (this.m_entriesToDeliver.isEmpty()) {
                    try {
                        this.m_entriesToDeliver.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (!this.m_stopping) continue;
            stop = true;
        }
    }
}

