/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.jboss.subject;

import java.security.Principal;
import java.util.Calendar;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.SubjectSecurityManager;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.bindings.tomcat.SubjectSecurityInteraction;
import org.picketlink.identity.federation.core.factories.JBossAuthCacheInvalidationFactory;

public class PicketLinkJBossSubjectInteraction
implements SubjectSecurityInteraction {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    @Override
    public boolean cleanup(Principal principal) {
        try {
            String securityDomain = this.getSecurityDomain();
            logger.trace("Determined Security Domain = " + securityDomain);
            JBossAuthCacheInvalidationFactory.TimeCacheExpiry cacheExpiry = JBossAuthCacheInvalidationFactory.getCacheExpiry();
            Calendar calendar = Calendar.getInstance();
            calendar.add(13, 10);
            logger.trace("Will expire from cache in 10 seconds, principal = " + principal);
            cacheExpiry.register(securityDomain, calendar.getTime(), principal);
            cacheExpiry.register(securityDomain, calendar.getTime(), (Principal)new SimplePrincipal(principal.getName()));
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    @Override
    public Subject get() {
        try {
            return (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
        }
        catch (PolicyContextException e) {
            throw new RuntimeException(e);
        }
    }

    private String getSecurityDomain() throws NamingException {
        InitialContext ctx = new InitialContext();
        SubjectSecurityManager ssm = (SubjectSecurityManager)ctx.lookup("java:comp/env/security/securityMgr");
        if (ssm == null) {
            throw logger.nullValueError("Unable to get the subject security manager");
        }
        return ssm.getSecurityDomain();
    }
}

