/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl;

import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.Type;
import com.kenai.jaffl.provider.MemoryManager;
import com.kenai.jaffl.provider.NativeType;
import java.util.Map;

public abstract class FFIProvider {
    public static final FFIProvider getProvider() {
        return SingletonHolder.INSTANCE;
    }

    public abstract MemoryManager getMemoryManager();

    public abstract <T> T loadLibrary(String var1, Class<T> var2, Map<LibraryOption, ?> var3);

    public abstract <T> T loadLibrary(Class<T> var1, Map<LibraryOption, ?> var2, String ... var3);

    public abstract int getLastError();

    public abstract void setLastError(int var1);

    public abstract Type getType(NativeType var1);

    protected FFIProvider() {
    }

    private static final class SingletonHolder {
        private static final FFIProvider INSTANCE = SingletonHolder.getInstance();

        private SingletonHolder() {
        }

        private static final FFIProvider getInstance() {
            boolean useJNA = Boolean.getBoolean("jaffl.usejna");
            FFIProvider provider = null;
            String prefix = FFIProvider.class.getPackage().getName() + ".provider";
            if (!useJNA) {
                try {
                    provider = (FFIProvider)Class.forName(prefix + ".jffi.Provider").newInstance();
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
            if (provider == null) {
                try {
                    provider = (FFIProvider)Class.forName(prefix + ".jna.JNAProvider").newInstance();
                }
                catch (Throwable ex) {
                    throw new RuntimeException("Could not load FFI provider", ex);
                }
            }
            return provider;
        }
    }
}

