/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.Platform;

public abstract class PageManager {
    public static final int PROT_EXEC = 4;
    public static final int PROT_READ = 1;
    public static final int PROT_WRITE = 2;
    private final Foreign foreign = Foreign.getInstance();

    final Foreign getForeign() {
        return this.foreign;
    }

    public static final PageManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public final long pageSize() {
        return this.getForeign().pageSize();
    }

    public abstract long allocatePages(int var1, int var2);

    public abstract void freePages(long var1, int var3);

    public abstract void protectPages(long var1, int var3, int var4);

    static final class Windows
    extends PageManager {
        @Override
        public long allocatePages(int npages, int protection) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void freePages(long address, int npages) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void protectPages(long address, int npages, int protection) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    static final class Unix
    extends PageManager {
        Unix() {
        }

        @Override
        public long allocatePages(int npages, int protection) {
            long sz = (long)npages * this.pageSize();
            return this.getForeign().mmap(0L, sz, protection, 258, -1, 0L);
        }

        @Override
        public void freePages(long address, int npages) {
            this.getForeign().munmap(address, (long)npages * this.pageSize());
        }

        @Override
        public void protectPages(long address, int npages, int protection) {
            this.getForeign().mprotect(address, (long)npages * this.pageSize(), protection);
        }
    }

    private static final class SingletonHolder {
        public static final PageManager INSTANCE = Platform.getPlatform().getOS() == Platform.OS.WINDOWS ? new Windows() : new Unix();

        private SingletonHolder() {
        }
    }
}

