/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.dom;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.python.apache.xerces.dom.SecuritySupport;

final class ObjectFactory {
    private static final String DEFAULT_PROPERTIES_FILENAME = "xerces.properties";
    private static final boolean DEBUG = false;
    private static final int DEFAULT_LINE_LENGTH = 80;
    private static Properties fXercesProperties = null;
    private static long fLastModified = -1L;

    ObjectFactory() {
    }

    static Object createObject(String string, String string2) throws ConfigurationError {
        return ObjectFactory.createObject(string, null, string2);
    }

    static Object createObject(String string, String string2, String string3) throws ConfigurationError {
        try {
            return Class.forName(string3).newInstance();
        }
        catch (Exception exception) {
            throw new ConfigurationError(exception.getMessage(), exception);
        }
    }

    private static void debugPrintln(String string) {
    }

    static ClassLoader findClassLoader() throws ConfigurationError {
        return ObjectFactory.class.getClassLoader();
    }

    static Object newInstance(String string, ClassLoader classLoader, boolean bl) throws ConfigurationError {
        try {
            Class clazz = ObjectFactory.findProviderClass(string, classLoader, bl);
            Object t = clazz.newInstance();
            return t;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    static Class findProviderClass(String string, ClassLoader classLoader, boolean bl) throws ClassNotFoundException, ConfigurationError {
        return Class.forName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findJarServiceProvider(String string) throws ConfigurationError {
        Object object;
        String string2 = "META-INF/services/" + string;
        InputStream inputStream = null;
        ClassLoader classLoader = ObjectFactory.findClassLoader();
        inputStream = SecuritySupport.getResourceAsStream(classLoader, string2);
        if (inputStream == null && classLoader != (object = ObjectFactory.class.getClassLoader())) {
            classLoader = object;
            inputStream = SecuritySupport.getResourceAsStream(classLoader, string2);
        }
        if (inputStream == null) {
            return null;
        }
        try {
            object = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"), 80);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = new BufferedReader(new InputStreamReader(inputStream), 80);
        }
        String string3 = null;
        try {
            string3 = ((BufferedReader)object).readLine();
        }
        catch (IOException iOException) {
            Object var7_9 = null;
            return var7_9;
        }
        finally {
            try {
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {}
        }
        if (string3 != null && !"".equals(string3)) {
            return ObjectFactory.newInstance(string3, classLoader, false);
        }
        return null;
    }

    static final class ConfigurationError
    extends Error {
        static final long serialVersionUID = 1914065341994951202L;
        private Exception exception;

        ConfigurationError(String string, Exception exception) {
            super(string);
            this.exception = exception;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

