/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.impl.xs.util;

import org.python.apache.xerces.xs.ShortList;
import org.python.apache.xerces.xs.XSException;

public class ShortListImpl
implements ShortList {
    public static final ShortList EMPTY_LIST = new ShortList(){

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public boolean contains(short s) {
            return false;
        }

        @Override
        public short item(int n) throws XSException {
            throw new XSException(2, null);
        }
    };
    private short[] fArray = null;
    private int fLength = 0;

    public ShortListImpl(short[] sArray, int n) {
        this.fArray = sArray;
        this.fLength = n;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public boolean contains(short s) {
        for (int i = 0; i < this.fLength; ++i) {
            if (this.fArray[i] != s) continue;
            return true;
        }
        return false;
    }

    @Override
    public short item(int n) throws XSException {
        if (n < 0 || n >= this.fLength) {
            throw new XSException(2, null);
        }
        return this.fArray[n];
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ShortList)) {
            return false;
        }
        ShortList shortList = (ShortList)object;
        if (this.fLength != shortList.getLength()) {
            return false;
        }
        for (int i = 0; i < this.fLength; ++i) {
            if (this.fArray[i] == shortList.item(i)) continue;
            return false;
        }
        return true;
    }
}

