/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.impl.xs.util;

import org.python.apache.xerces.util.SymbolHash;
import org.python.apache.xerces.xni.QName;
import org.python.apache.xerces.xs.XSNamedMap;
import org.python.apache.xerces.xs.XSObject;

public class XSNamedMapImpl
implements XSNamedMap {
    public static final XSNamedMap EMPTY_MAP = new XSNamedMap(){

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public XSObject itemByName(String string, String string2) {
            return null;
        }

        @Override
        public XSObject item(int n) {
            return null;
        }
    };
    String[] fNamespaces;
    int fNSNum;
    SymbolHash[] fMaps;
    XSObject[] fArray = null;
    int fLength = -1;
    QName fName = new QName();

    public XSNamedMapImpl(String string, SymbolHash symbolHash) {
        this.fNamespaces = new String[]{string};
        this.fMaps = new SymbolHash[]{symbolHash};
        this.fNSNum = 1;
    }

    public XSNamedMapImpl(String[] stringArray, SymbolHash[] symbolHashArray, int n) {
        this.fNamespaces = stringArray;
        this.fMaps = symbolHashArray;
        this.fNSNum = n;
    }

    public XSNamedMapImpl(XSObject[] xSObjectArray, int n) {
        if (n == 0) {
            this.fNSNum = 0;
            this.fLength = 0;
            return;
        }
        this.fNamespaces = new String[]{xSObjectArray[0].getNamespace()};
        this.fMaps = null;
        this.fNSNum = 1;
        this.fArray = xSObjectArray;
        this.fLength = n;
    }

    @Override
    public synchronized int getLength() {
        if (this.fLength == -1) {
            this.fLength = 0;
            for (int i = 0; i < this.fNSNum; ++i) {
                this.fLength += this.fMaps[i].getLength();
            }
        }
        return this.fLength;
    }

    @Override
    public XSObject itemByName(String string, String string2) {
        for (int i = 0; i < this.fNSNum; ++i) {
            if (!this.isEqual(string, this.fNamespaces[i])) continue;
            if (this.fMaps != null) {
                return (XSObject)this.fMaps[i].get(string2);
            }
            for (int j = 0; j < this.fLength; ++j) {
                XSObject xSObject = this.fArray[j];
                if (!xSObject.getName().equals(string2)) continue;
                return xSObject;
            }
            return null;
        }
        return null;
    }

    @Override
    public synchronized XSObject item(int n) {
        if (this.fArray == null) {
            this.getLength();
            this.fArray = new XSObject[this.fLength];
            int n2 = 0;
            for (int i = 0; i < this.fNSNum; ++i) {
                n2 += this.fMaps[i].getValues(this.fArray, n2);
            }
        }
        if (n < 0 || n >= this.fLength) {
            return null;
        }
        return this.fArray[n];
    }

    final boolean isEqual(String string, String string2) {
        return string != null ? string.equals(string2) : string2 == null;
    }
}

