/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.text.NumberFormat;
import java.util.Locale;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyUnicode;
import org.python.core.codecs;
import org.python.core.util.ExtraMath;

final class StringFormatter {
    int index = 0;
    String format;
    StringBuilder buffer;
    boolean negative;
    int precision;
    int argIndex;
    PyObject args;
    boolean unicodeCoercion;

    final char pop() {
        try {
            return this.format.charAt(this.index++);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw Py.ValueError("incomplete format");
        }
    }

    final char peek() {
        return this.format.charAt(this.index);
    }

    final void push() {
        --this.index;
    }

    public StringFormatter(String format) {
        this(format, false);
    }

    public StringFormatter(String format, boolean unicodeCoercion) {
        this.format = format;
        this.unicodeCoercion = unicodeCoercion;
        this.buffer = new StringBuilder(format.length() + 100);
    }

    PyObject getarg() {
        PyObject ret = null;
        switch (this.argIndex) {
            case -3: {
                return this.args;
            }
            case -2: {
                break;
            }
            case -1: {
                this.argIndex = -2;
                return this.args;
            }
            default: {
                ret = this.args.__finditem__(this.argIndex++);
            }
        }
        if (ret == null) {
            throw Py.TypeError("not enough arguments for format string");
        }
        return ret;
    }

    int getNumber() {
        char c = this.pop();
        if (c == '*') {
            PyObject o = this.getarg();
            if (o instanceof PyInteger) {
                return ((PyInteger)o).getValue();
            }
            throw Py.TypeError("* wants int");
        }
        if (Character.isDigit(c)) {
            int numStart = this.index - 1;
            while (Character.isDigit(c = this.pop())) {
            }
            --this.index;
            Integer i = Integer.valueOf(this.format.substring(numStart, this.index));
            return i;
        }
        --this.index;
        return 0;
    }

    private void checkPrecision(String type) {
        if (this.precision > 250) {
            throw Py.OverflowError("formatted " + type + " is too long (precision too long?)");
        }
    }

    private String formatLong(PyObject arg, char type, boolean altFlag) {
        PyString argAsString;
        switch (type) {
            case 'o': {
                argAsString = arg.__oct__();
                break;
            }
            case 'X': 
            case 'x': {
                argAsString = arg.__hex__();
                break;
            }
            default: {
                argAsString = arg.__str__();
            }
        }
        this.checkPrecision("long");
        String s = argAsString.toString();
        int end = s.length();
        int ptr = 0;
        int numnondigits = 0;
        if (type == 'x' || type == 'X') {
            numnondigits = 2;
        }
        if (s.endsWith("L")) {
            --end;
        }
        boolean bl = this.negative = s.charAt(0) == '-';
        if (this.negative) {
            ++ptr;
        }
        int numdigits = end - numnondigits - ptr;
        if (!altFlag) {
            switch (type) {
                case 'o': {
                    if (numdigits <= 1) break;
                    ++ptr;
                    --numdigits;
                    break;
                }
                case 'X': 
                case 'x': {
                    ptr += 2;
                    numnondigits -= 2;
                }
            }
        }
        if (this.precision > numdigits) {
            int i;
            StringBuilder buf = new StringBuilder();
            for (i = 0; i < numnondigits; ++i) {
                buf.append(s.charAt(ptr++));
            }
            for (i = 0; i < this.precision - numdigits; ++i) {
                buf.append('0');
            }
            for (i = 0; i < numdigits; ++i) {
                buf.append(s.charAt(ptr++));
            }
            s = buf.toString();
        } else if (end < s.length() || ptr > 0) {
            s = s.substring(ptr, end);
        }
        switch (type) {
            case 'X': {
                s = s.toUpperCase();
            }
        }
        return s;
    }

    private String formatInteger(PyObject arg, int radix, boolean unsigned, char type, boolean altFlag) {
        PyObject argAsInt;
        if (arg instanceof PyInteger || arg instanceof PyLong) {
            argAsInt = arg;
        } else if (arg instanceof PyFloat) {
            argAsInt = arg.__int__();
        } else {
            try {
                argAsInt = arg.__getattr__("__int__").__call__();
            }
            catch (PyException e) {
                if (e.match(Py.AttributeError)) {
                    throw Py.TypeError("int argument required");
                }
                throw e;
            }
        }
        if (argAsInt instanceof PyInteger) {
            return this.formatInteger(((PyInteger)argAsInt).getValue(), radix, unsigned);
        }
        return this.formatLong(argAsInt, type, altFlag);
    }

    private String formatInteger(long v, int radix, boolean unsigned) {
        this.checkPrecision("integer");
        if (unsigned) {
            if (v < 0L) {
                v = 0x100000000L + v;
            }
        } else if (v < 0L) {
            this.negative = true;
            v = -v;
        }
        String s = Long.toString(v, radix);
        while (s.length() < this.precision) {
            s = "0" + s;
        }
        return s;
    }

    private double asDouble(PyObject obj) {
        try {
            return obj.asDouble();
        }
        catch (PyException pye) {
            throw !pye.match(Py.TypeError) ? pye : Py.TypeError("float argument required");
        }
    }

    private String formatFloatDecimal(double v, boolean truncate) {
        this.checkPrecision("decimal");
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        int prec = this.precision;
        if (prec == -1) {
            prec = 6;
        }
        if (v < 0.0) {
            v = -v;
            this.negative = true;
        }
        numberFormat.setMaximumFractionDigits(prec);
        numberFormat.setMinimumFractionDigits(truncate ? 0 : prec);
        numberFormat.setGroupingUsed(false);
        String ret = numberFormat.format(v);
        return ret;
    }

    private String formatFloatExponential(PyObject arg, char e, boolean truncate) {
        StringBuilder buf = new StringBuilder();
        double v = this.asDouble(arg);
        boolean isNegative = false;
        if (v < 0.0) {
            v = -v;
            isNegative = true;
        }
        double power = 0.0;
        if (v > 0.0) {
            power = ExtraMath.closeFloor(Math.log10(v));
        }
        int savePrecision = this.precision;
        this.precision = 2;
        String exp = this.formatInteger((long)power, 10, false);
        if (this.negative) {
            this.negative = false;
            exp = '-' + exp;
        } else {
            exp = '+' + exp;
        }
        this.precision = savePrecision;
        double base = v / Math.pow(10.0, power);
        buf.append(this.formatFloatDecimal(base, truncate));
        buf.append(e);
        buf.append(exp);
        this.negative = isNegative;
        return buf.toString();
    }

    public PyString format(PyObject args) {
        PyObject dict = null;
        this.args = args;
        boolean needUnicode = this.unicodeCoercion;
        if (args instanceof PyTuple) {
            this.argIndex = 0;
        } else {
            this.argIndex = -1;
            if (args instanceof PyDictionary || args instanceof PyStringMap || !(args instanceof PySequence) && args.__findattr__("__getitem__") != null) {
                dict = args;
                this.argIndex = -3;
            }
        }
        while (this.index < this.format.length()) {
            boolean ljustFlag = false;
            boolean signFlag = false;
            boolean blankFlag = false;
            boolean altFlag = false;
            boolean zeroFlag = false;
            int width = -1;
            this.precision = -1;
            char c = this.pop();
            if (c != '%') {
                this.buffer.append(c);
                continue;
            }
            c = this.pop();
            if (c == '(') {
                if (dict == null) {
                    throw Py.TypeError("format requires a mapping");
                }
                int parens = 1;
                int keyStart = this.index;
                while (parens > 0) {
                    c = this.pop();
                    if (c == ')') {
                        --parens;
                        continue;
                    }
                    if (c != '(') continue;
                    ++parens;
                }
                String tmp = this.format.substring(keyStart, this.index - 1);
                this.args = dict.__getitem__(needUnicode ? new PyUnicode(tmp) : new PyString(tmp));
            } else {
                this.push();
            }
            block24: while (true) {
                c = this.pop();
                switch (c) {
                    case '-': {
                        ljustFlag = true;
                        continue block24;
                    }
                    case '+': {
                        signFlag = true;
                        continue block24;
                    }
                    case ' ': {
                        blankFlag = true;
                        continue block24;
                    }
                    case '#': {
                        altFlag = true;
                        continue block24;
                    }
                    case '0': {
                        zeroFlag = true;
                        continue block24;
                    }
                }
                break;
            }
            this.push();
            width = this.getNumber();
            if (width < 0) {
                width = -width;
                ljustFlag = true;
            }
            if ((c = this.pop()) == '.') {
                this.precision = this.getNumber();
                if (this.precision < -1) {
                    this.precision = 0;
                }
                c = this.pop();
            }
            if (c == 'h' || c == 'l' || c == 'L') {
                c = this.pop();
            }
            if (c == '%') {
                this.buffer.append(c);
                continue;
            }
            PyObject arg = this.getarg();
            char fill = ' ';
            String string = null;
            this.negative = false;
            fill = zeroFlag ? (char)'0' : ' ';
            switch (c) {
                case 's': {
                    if (arg instanceof PyUnicode) {
                        needUnicode = true;
                    }
                }
                case 'r': {
                    fill = ' ';
                    string = c == 's' ? (needUnicode ? arg.__unicode__().toString() : arg.__str__().toString()) : arg.__repr__().toString();
                    if (this.precision < 0 || string.length() <= this.precision) break;
                    string = string.substring(0, this.precision);
                    break;
                }
                case 'd': 
                case 'i': {
                    if (arg instanceof PyLong) {
                        string = this.formatLong(arg, c, altFlag);
                        break;
                    }
                    string = this.formatInteger(arg, 10, false, c, altFlag);
                    break;
                }
                case 'u': {
                    if (arg instanceof PyLong) {
                        string = this.formatLong(arg, c, altFlag);
                        break;
                    }
                    if (arg instanceof PyInteger || arg instanceof PyFloat) {
                        string = this.formatInteger(arg, 10, false, c, altFlag);
                        break;
                    }
                    throw Py.TypeError("int argument required");
                }
                case 'o': {
                    if (arg instanceof PyLong) {
                        string = this.formatLong(arg, c, altFlag);
                        break;
                    }
                    if (arg instanceof PyInteger || arg instanceof PyFloat) {
                        string = this.formatInteger(arg, 8, false, c, altFlag);
                        if (!altFlag || string.charAt(0) == '0') break;
                        string = "0" + string;
                        break;
                    }
                    throw Py.TypeError("int argument required");
                }
                case 'x': {
                    if (arg instanceof PyLong) {
                        string = this.formatLong(arg, c, altFlag);
                        break;
                    }
                    if (arg instanceof PyInteger || arg instanceof PyFloat) {
                        string = this.formatInteger(arg, 16, false, c, altFlag);
                        string = string.toLowerCase();
                        if (!altFlag) break;
                        string = "0x" + string;
                        break;
                    }
                    throw Py.TypeError("int argument required");
                }
                case 'X': {
                    if (arg instanceof PyLong) {
                        string = this.formatLong(arg, c, altFlag);
                        break;
                    }
                    if (arg instanceof PyInteger || arg instanceof PyFloat) {
                        string = this.formatInteger(arg, 16, false, c, altFlag);
                        string = string.toUpperCase();
                        if (!altFlag) break;
                        string = "0X" + string;
                        break;
                    }
                    throw Py.TypeError("int argument required");
                }
                case 'E': 
                case 'e': {
                    string = this.formatFloatExponential(arg, c, false);
                    break;
                }
                case 'F': 
                case 'f': {
                    string = this.formatFloatDecimal(this.asDouble(arg), false);
                    break;
                }
                case 'G': 
                case 'g': {
                    double v;
                    int origPrecision = this.precision;
                    if (this.precision == -1) {
                        this.precision = 6;
                    }
                    int exponent = (int)ExtraMath.closeFloor(Math.log10(Math.abs((v = this.asDouble(arg)) == 0.0 ? 1.0 : v)));
                    if (v == Double.POSITIVE_INFINITY) {
                        string = "inf";
                        break;
                    }
                    if (v == Double.NEGATIVE_INFINITY) {
                        string = "-inf";
                        break;
                    }
                    if (exponent >= -4 && exponent < this.precision) {
                        this.precision -= exponent + 1;
                        string = this.formatFloatDecimal(v, !altFlag);
                        if (!altFlag || string.indexOf(46) != -1) break;
                        int zpad = origPrecision - string.length();
                        string = string + '.';
                        if (zpad <= 0) break;
                        char[] zeros = new char[zpad];
                        int ci = 0;
                        while (ci < zpad) {
                            zeros[ci++] = 48;
                        }
                        string = string + new String(zeros);
                        break;
                    }
                    --this.precision;
                    string = this.formatFloatExponential(arg, (char)(c - 2), !altFlag);
                    break;
                }
                case 'c': {
                    int val;
                    fill = ' ';
                    if (arg instanceof PyString) {
                        string = ((PyString)arg).toString();
                        if (string.length() != 1) {
                            throw Py.TypeError("%c requires int or char");
                        }
                        if (!(arg instanceof PyUnicode)) break;
                        needUnicode = true;
                        break;
                    }
                    try {
                        val = arg.__int__().asInt();
                    }
                    catch (PyException e) {
                        if (e.match(Py.AttributeError)) {
                            throw Py.TypeError("%c requires int or char");
                        }
                        throw e;
                    }
                    if (!needUnicode) {
                        if (val < 0) {
                            throw Py.OverflowError("unsigned byte integer is less than minimum");
                        }
                        if (val > 255) {
                            throw Py.OverflowError("unsigned byte integer is greater than maximum");
                        }
                    } else if (val < 0 || val > 0x10FFFF) {
                        throw Py.OverflowError("%c arg not in range(0x110000) (wide Python build)");
                    }
                    string = new String(new int[]{val}, 0, 1);
                    break;
                }
                default: {
                    throw Py.ValueError("unsupported format character '" + codecs.encode(Py.newString(c), null, "replace") + "' (0x" + Integer.toHexString(c) + ") at index " + (this.index - 1));
                }
            }
            int length = string.length();
            int skip = 0;
            String signString = null;
            if (this.negative) {
                signString = "-";
            } else if (signFlag) {
                signString = "+";
            } else if (blankFlag) {
                signString = " ";
            }
            if (width < length) {
                width = length;
            }
            if (signString != null) {
                if (fill != ' ') {
                    this.buffer.append(signString);
                }
                if (width > length) {
                    --width;
                }
            }
            if (altFlag && (c == 'x' || c == 'X')) {
                if (fill != ' ') {
                    this.buffer.append('0');
                    this.buffer.append(c);
                    skip += 2;
                }
                if ((width -= 2) < 0) {
                    width = 0;
                }
                length -= 2;
            }
            if (width > length && !ljustFlag) {
                do {
                    this.buffer.append(fill);
                } while (--width > length);
            }
            if (fill == ' ') {
                if (signString != null) {
                    this.buffer.append(signString);
                }
                if (altFlag && (c == 'x' || c == 'X')) {
                    this.buffer.append('0');
                    this.buffer.append(c);
                    skip += 2;
                }
            }
            if (skip > 0) {
                this.buffer.append(string.substring(skip));
            } else {
                this.buffer.append(string);
            }
            while (--width >= length) {
                this.buffer.append(' ');
            }
        }
        if (this.argIndex == -1 || this.argIndex >= 0 && args.__finditem__(this.argIndex) != null) {
            throw Py.TypeError("not all arguments converted during string formatting");
        }
        if (needUnicode) {
            return new PyUnicode(this.buffer);
        }
        return new PyString(this.buffer);
    }
}

