/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.io.BufferedIOBase;
import org.python.core.io.TextIOBase;

public class UniversalIOWrapper
extends TextIOBase {
    private boolean skipNextLF = false;
    private EnumSet<Newline> newlineTypes = EnumSet.noneOf(Newline.class);

    public UniversalIOWrapper(BufferedIOBase bufferedIO) {
        super(bufferedIO);
    }

    public String read(int size) {
        int readaheadPos;
        if (size < 0) {
            return this.readall();
        }
        char[] builderArray = new char[size];
        int builderPos = 0;
        do {
            byte[] readaheadArray = this.readahead.array();
            readaheadPos = this.readahead.position();
            block5: while (readaheadPos < this.readahead.limit() && builderPos < size) {
                int next = readaheadArray[readaheadPos++] & 0xFF;
                switch (next) {
                    case 13: {
                        next = 10;
                        if (readaheadPos == this.readahead.limit()) {
                            if (this.readChunk() == 0) {
                                this.newlineTypes.add(Newline.CR);
                                builderArray[builderPos++] = next;
                                return new String(builderArray, 0, builderPos);
                            }
                            readaheadArray = this.readahead.array();
                            readaheadPos = this.readahead.position();
                        }
                        this.skipNextLF = true;
                        break;
                    }
                    case 10: {
                        if (this.skipNextLF) {
                            this.skipNextLF = false;
                            this.newlineTypes.add(Newline.CRLF);
                            continue block5;
                        }
                        this.newlineTypes.add(Newline.LF);
                        break;
                    }
                    default: {
                        if (!this.skipNextLF) break;
                        this.skipNextLF = false;
                        this.newlineTypes.add(Newline.CR);
                    }
                }
                builderArray[builderPos++] = next;
            }
        } while (builderPos < size && this.readChunk(size - builderPos) > 0);
        if (this.readahead.hasRemaining()) {
            this.readahead.position(readaheadPos);
        }
        this.packReadahead();
        return new String(builderArray, 0, builderPos);
    }

    public String readall() {
        ByteBuffer remaining = this.bufferedIO.readall();
        char[] all = new char[this.readahead.remaining() + remaining.remaining()];
        int length = this.readLoop(this.readahead.array(), this.readahead.position(), all, 0, this.readahead.remaining());
        this.readahead.position(this.readahead.limit());
        length += this.readLoop(remaining.array(), remaining.position(), all, length, remaining.remaining());
        if (this.skipNextLF) {
            this.skipNextLF = false;
            this.newlineTypes.add(Newline.CR);
        }
        return new String(all, 0, length);
    }

    private int readLoop(byte[] src, int srcPos, char[] dest, int destPos, int length) {
        int destStartPos = destPos;
        int srcEndPos = srcPos + length;
        block4: while (srcPos < srcEndPos) {
            int next = src[srcPos++] & 0xFF;
            switch (next) {
                case 13: {
                    next = 10;
                    this.skipNextLF = true;
                    break;
                }
                case 10: {
                    if (this.skipNextLF) {
                        this.skipNextLF = false;
                        this.newlineTypes.add(Newline.CRLF);
                        continue block4;
                    }
                    this.newlineTypes.add(Newline.LF);
                    break;
                }
                default: {
                    if (!this.skipNextLF) break;
                    this.skipNextLF = false;
                    this.newlineTypes.add(Newline.CR);
                }
            }
            dest[destPos++] = next;
        }
        return destPos - destStartPos;
    }

    public String readline(int size) {
        int readaheadPos;
        do {
            byte[] readaheadArray = this.readahead.array();
            readaheadPos = this.readahead.position();
            int interimBuilderPos = 0;
            block5: while (readaheadPos < this.readahead.limit() && (size < 0 || this.builder.length() + interimBuilderPos < size)) {
                int next = readaheadArray[readaheadPos++] & 0xFF;
                switch (next) {
                    case 13: {
                        next = 10;
                        if (readaheadPos == this.readahead.limit()) {
                            if (this.readChunk() == 0) {
                                this.newlineTypes.add(Newline.CR);
                                this.interimBuilder[interimBuilderPos++] = next;
                                this.builder.append(this.interimBuilder, 0, interimBuilderPos);
                                return this.drainBuilder();
                            }
                            readaheadPos = this.readahead.position();
                        }
                        this.skipNextLF = true;
                        this.interimBuilder[interimBuilderPos++] = next;
                        this.builder.append(this.interimBuilder, 0, interimBuilderPos);
                        this.readahead.position(readaheadPos);
                        return this.drainBuilder();
                    }
                    case 10: {
                        if (this.skipNextLF) {
                            this.skipNextLF = false;
                            this.newlineTypes.add(Newline.CRLF);
                            continue block5;
                        }
                        this.newlineTypes.add(Newline.LF);
                        this.interimBuilder[interimBuilderPos++] = next;
                        this.builder.append(this.interimBuilder, 0, interimBuilderPos);
                        this.readahead.position(readaheadPos);
                        return this.drainBuilder();
                    }
                }
                if (this.skipNextLF) {
                    this.skipNextLF = false;
                    this.newlineTypes.add(Newline.CR);
                }
                this.interimBuilder[interimBuilderPos++] = next;
            }
            this.builder.append(this.interimBuilder, 0, interimBuilderPos);
        } while ((size < 0 || this.builder.length() < size) && this.readChunk() > 0);
        if (this.readahead.hasRemaining()) {
            this.readahead.position(readaheadPos);
        }
        return this.drainBuilder();
    }

    public int write(String buf) {
        this.checkClosed();
        this.checkWritable();
        return -1;
    }

    public long seek(long pos, int whence) {
        pos = super.seek(pos, whence);
        this.skipNextLF = false;
        return pos;
    }

    public long tell() {
        int readaheadPos;
        long pos = super.tell();
        if (this.skipNextLF && !this.atEOF() && this.readahead.get(readaheadPos = this.readahead.position()) == 10) {
            this.skipNextLF = false;
            this.newlineTypes.add(Newline.CRLF);
            this.readahead.position(++readaheadPos);
            ++pos;
        }
        return pos;
    }

    public PyObject getNewlines() {
        int size = this.newlineTypes.size();
        if (size == 0) {
            return Py.None;
        }
        if (size == 1) {
            Newline newline = (Newline)((Object)this.newlineTypes.iterator().next());
            return new PyString(newline.getValue());
        }
        PyObject[] newlines = new PyObject[size];
        int i = 0;
        for (Newline newline : this.newlineTypes) {
            newlines[i++] = new PyString(newline.getValue());
        }
        return new PyTuple(newlines);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Newline {
        CR("\r"),
        LF("\n"),
        CRLF("\r\n");

        private final String value;

        public String getValue() {
            return this.value;
        }

        private Newline(String value) {
            this.value = value;
        }
    }
}

