/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.python.google.common.collect.ImmutableMap;
import org.python.google.common.collect.ImmutableMultiset;
import org.python.google.common.collect.ImmutableSet;
import org.python.google.common.collect.Multiset;
import org.python.google.common.collect.Multisets;
import org.python.google.common.collect.UnmodifiableIterator;

@GwtCompatible(serializable=true)
class RegularImmutableMultiset<E>
extends ImmutableMultiset<E> {
    private final transient ImmutableMap<E, Integer> map;
    private final transient int size;

    RegularImmutableMultiset(ImmutableMap<E, Integer> map, int size) {
        this.map = map;
        this.size = size;
    }

    @Override
    boolean isPartialView() {
        return this.map.isPartialView();
    }

    @Override
    public int count(@Nullable Object element) {
        Integer value = this.map.get(element);
        return value == null ? 0 : value;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(@Nullable Object element) {
        return this.map.containsKey(element);
    }

    @Override
    public ImmutableSet<E> elementSet() {
        return this.map.keySet();
    }

    @Override
    UnmodifiableIterator<Multiset.Entry<E>> entryIterator() {
        final Iterator mapIterator = ((ImmutableSet)this.map.entrySet()).iterator();
        return new UnmodifiableIterator<Multiset.Entry<E>>(){

            @Override
            public boolean hasNext() {
                return mapIterator.hasNext();
            }

            @Override
            public Multiset.Entry<E> next() {
                Map.Entry mapEntry = (Map.Entry)mapIterator.next();
                return Multisets.immutableEntry(mapEntry.getKey(), (Integer)mapEntry.getValue());
            }
        };
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    int distinctElements() {
        return this.map.size();
    }
}

