/*
 * Decompiled with CFR 0.152.
 */
package org.python.posix;

import java.io.FileDescriptor;
import java.io.IOException;
import org.python.posix.FileStat;
import org.python.posix.Group;
import org.python.posix.LibC;
import org.python.posix.POSIX;
import org.python.posix.POSIXFactory;
import org.python.posix.POSIXHandler;
import org.python.posix.Passwd;

final class LazyPOSIX
implements POSIX {
    private final POSIXHandler handler;
    private final boolean useNativePosix;
    private volatile POSIX posix;

    LazyPOSIX(POSIXHandler handler, boolean useNativePosix) {
        this.handler = handler;
        this.useNativePosix = useNativePosix;
    }

    private final POSIX posix() {
        return this.posix != null ? this.posix : this.loadPOSIX();
    }

    private final synchronized POSIX loadPOSIX() {
        return this.posix != null ? this.posix : (this.posix = POSIXFactory.loadPOSIX(this.handler, this.useNativePosix));
    }

    @Override
    public FileStat allocateStat() {
        return this.posix().allocateStat();
    }

    @Override
    public int chmod(String filename, int mode) {
        return this.posix().chmod(filename, mode);
    }

    @Override
    public int chown(String filename, int user, int group) {
        return this.posix().chown(filename, user, group);
    }

    @Override
    public int endgrent() {
        return this.posix().endgrent();
    }

    @Override
    public int endpwent() {
        return this.posix().endpwent();
    }

    @Override
    public int errno() {
        return this.posix().errno();
    }

    @Override
    public void errno(int value) {
        this.posix().errno(value);
    }

    @Override
    public int exec(String path, String ... args) {
        return this.posix().exec(path, args);
    }

    @Override
    public int exec(String path, String[] args, String[] envp) {
        return this.posix().exec(path, args, envp);
    }

    @Override
    public int execv(String path, String[] argv) {
        return this.posix().execv(path, argv);
    }

    @Override
    public int execve(String path, String[] argv, String[] envp) {
        return this.posix().execve(path, argv, envp);
    }

    @Override
    public int fork() {
        return this.posix().fork();
    }

    @Override
    public FileStat fstat(FileDescriptor descriptor) {
        return this.posix().fstat(descriptor);
    }

    @Override
    public int getegid() {
        return this.posix().getegid();
    }

    @Override
    public int geteuid() {
        return this.posix().geteuid();
    }

    @Override
    public int getgid() {
        return this.posix().getgid();
    }

    @Override
    public Group getgrent() {
        return this.posix().getgrent();
    }

    @Override
    public Group getgrgid(int which) {
        return this.posix().getgrgid(which);
    }

    @Override
    public Group getgrnam(String which) {
        return this.posix().getgrnam(which);
    }

    @Override
    public String getlogin() {
        return this.posix().getlogin();
    }

    @Override
    public int getpgid() {
        return this.posix().getpgid();
    }

    @Override
    public int getpgid(int pid) {
        return this.posix().getpgid(pid);
    }

    @Override
    public int getpgrp() {
        return this.posix().getpgrp();
    }

    @Override
    public int getpid() {
        return this.posix().getpid();
    }

    @Override
    public int getppid() {
        return this.posix().getppid();
    }

    @Override
    public int getpriority(int which, int who) {
        return this.posix().getpriority(which, who);
    }

    @Override
    public Passwd getpwent() {
        return this.posix().getpwent();
    }

    @Override
    public Passwd getpwnam(String which) {
        return this.posix().getpwnam(which);
    }

    @Override
    public Passwd getpwuid(int which) {
        return this.posix().getpwuid(which);
    }

    @Override
    public int getuid() {
        return this.posix().getuid();
    }

    @Override
    public boolean isatty(FileDescriptor descriptor) {
        return this.posix().isatty(descriptor);
    }

    @Override
    public int kill(int pid, int signal) {
        return this.posix().kill(pid, signal);
    }

    @Override
    public int lchmod(String filename, int mode) {
        return this.posix().lchmod(filename, mode);
    }

    @Override
    public int lchown(String filename, int user, int group) {
        return this.posix().lchown(filename, user, group);
    }

    @Override
    public int link(String oldpath, String newpath) {
        return this.posix().link(oldpath, newpath);
    }

    @Override
    public FileStat lstat(String path) {
        return this.posix().lstat(path);
    }

    @Override
    public int mkdir(String path, int mode) {
        return this.posix().mkdir(path, mode);
    }

    @Override
    public String readlink(String path) throws IOException {
        return this.posix().readlink(path);
    }

    @Override
    public int setegid(int egid) {
        return this.posix().setegid(egid);
    }

    @Override
    public int seteuid(int euid) {
        return this.posix().seteuid(euid);
    }

    @Override
    public int setgid(int gid) {
        return this.posix().setgid(gid);
    }

    @Override
    public int setgrent() {
        return this.posix().setgrent();
    }

    @Override
    public int setpgid(int pid, int pgid) {
        return this.posix().setpgid(pid, pgid);
    }

    @Override
    public int setpgrp(int pid, int pgrp) {
        return this.posix().setpgrp(pid, pgrp);
    }

    @Override
    public int setpriority(int which, int who, int prio) {
        return this.posix().setpriority(which, who, prio);
    }

    @Override
    public int setpwent() {
        return this.posix().setpwent();
    }

    @Override
    public int setsid() {
        return this.posix().setsid();
    }

    @Override
    public int setuid(int uid) {
        return this.posix().setuid(uid);
    }

    @Override
    public FileStat stat(String path) {
        return this.posix().stat(path);
    }

    @Override
    public int symlink(String oldpath, String newpath) {
        return this.posix().symlink(oldpath, newpath);
    }

    @Override
    public int umask(int mask) {
        return this.posix().umask(mask);
    }

    @Override
    public int utimes(String path, long[] atimeval, long[] mtimeval) {
        return this.posix().utimes(path, atimeval, mtimeval);
    }

    @Override
    public int wait(int[] status) {
        return this.posix().wait(status);
    }

    @Override
    public int waitpid(int pid, int[] status, int flags) {
        return this.posix().waitpid(pid, status, flags);
    }

    @Override
    public boolean isNative() {
        return this.posix().isNative();
    }

    @Override
    public LibC libc() {
        return this.posix().libc();
    }

    @Override
    public String getenv(String envName) {
        return this.posix().getenv(envName);
    }

    @Override
    public int setenv(String envName, String envValue, int overwrite) {
        return this.posix().setenv(envName, envValue, overwrite);
    }

    @Override
    public int unsetenv(String envName) {
        return this.posix().unsetenv(envName);
    }
}

