/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import java.util.Set;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.InvocationContextFlagsOverride;
import org.infinispan.remoting.transport.Address;

public abstract class AbstractInvocationContextContainer
implements InvocationContextContainer {
    protected final ThreadLocal<InvocationContext> ctxHolder = new ThreadLocal();

    @Override
    public InvocationContext createRemoteInvocationContextForCommand(VisitableCommand cacheCommand, Address origin) {
        if (cacheCommand instanceof FlagAffectedCommand) {
            InvocationContext context = this.createRemoteInvocationContext(origin);
            FlagAffectedCommand command = (FlagAffectedCommand)((Object)cacheCommand);
            Set<Flag> flags = command.getFlags();
            if (flags != null && !flags.isEmpty()) {
                context = new InvocationContextFlagsOverride(context, flags);
                this.ctxHolder.set(context);
            }
            return context;
        }
        return this.createRemoteInvocationContext(origin);
    }

    @Override
    public InvocationContext getInvocationContext(boolean quiet) {
        InvocationContext ctx = this.ctxHolder.get();
        if (ctx == null && !quiet) {
            throw new IllegalStateException("No InvocationContext associated with current thread!");
        }
        return ctx;
    }

    @Override
    public void clearThreadLocal() {
        this.ctxHolder.remove();
    }
}

