/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.service;

import java.lang.reflect.Constructor;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.session.AbstractIoSession;
import org.apache.mina.core.session.AttributeKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleIoProcessorPool<T extends AbstractIoSession>
implements IoProcessor<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleIoProcessorPool.class);
    private static final int DEFAULT_SIZE = Runtime.getRuntime().availableProcessors() + 1;
    private static final AttributeKey PROCESSOR = new AttributeKey(SimpleIoProcessorPool.class, "processor");
    private final IoProcessor<T>[] pool;
    private final Executor executor;
    private final boolean createdExecutor;
    private final Object disposalLock = new Object();
    private volatile boolean disposing;
    private volatile boolean disposed;

    public SimpleIoProcessorPool(Class<? extends IoProcessor<T>> processorType) {
        this(processorType, null, DEFAULT_SIZE);
    }

    public SimpleIoProcessorPool(Class<? extends IoProcessor<T>> processorType, int size) {
        this(processorType, null, size);
    }

    public SimpleIoProcessorPool(Class<? extends IoProcessor<T>> processorType, Executor executor) {
        this(processorType, executor, DEFAULT_SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleIoProcessorPool(Class<? extends IoProcessor<T>> processorType, Executor executor, int size) {
        if (processorType == null) {
            throw new IllegalArgumentException("processorType");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("size: " + size + " (expected: positive integer)");
        }
        this.createdExecutor = executor == null;
        this.executor = this.createdExecutor ? Executors.newCachedThreadPool() : executor;
        this.pool = new IoProcessor[size];
        boolean success = false;
        Constructor<IoProcessor<T>> processorConstructor = null;
        boolean usesExecutorArg = true;
        try {
            try {
                try {
                    processorConstructor = processorType.getConstructor(ExecutorService.class);
                    this.pool[0] = processorConstructor.newInstance(this.executor);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                try {
                    processorConstructor = processorType.getConstructor(Executor.class);
                    this.pool[0] = processorConstructor.newInstance(this.executor);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                try {
                    processorConstructor = processorType.getConstructor(new Class[0]);
                    usesExecutorArg = false;
                    this.pool[0] = processorConstructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {}
            }
            catch (RuntimeException re) {
                LOGGER.error("Cannot create an IoProcessor :{}", (Object)re.getMessage());
                throw re;
            }
            catch (Exception e) {
                String msg = "Failed to create a new instance of " + processorType.getName() + ":" + e.getMessage();
                LOGGER.error(msg, (Throwable)e);
                throw new RuntimeIoException(msg, e);
            }
            if (processorConstructor == null) {
                String msg = String.valueOf(processorType) + " must have a public constructor with one " + ExecutorService.class.getSimpleName() + " parameter, a public constructor with one " + Executor.class.getSimpleName() + " parameter or a public default constructor.";
                LOGGER.error(msg);
                throw new IllegalArgumentException(msg);
            }
            for (int i = 1; i < this.pool.length; ++i) {
                try {
                    if (usesExecutorArg) {
                        this.pool[i] = processorConstructor.newInstance(this.executor);
                        continue;
                    }
                    this.pool[i] = processorConstructor.newInstance(new Object[0]);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                this.dispose();
            }
        }
    }

    @Override
    public final void add(T session) {
        this.getProcessor(session).add(session);
    }

    @Override
    public final void flush(T session) {
        this.getProcessor(session).flush(session);
    }

    @Override
    public final void remove(T session) {
        this.getProcessor(session).remove(session);
    }

    @Override
    public final void updateTrafficControl(T session) {
        this.getProcessor(session).updateTrafficControl(session);
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public boolean isDisposing() {
        return this.disposing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        if (this.disposed) {
            return;
        }
        Object object = this.disposalLock;
        synchronized (object) {
            if (!this.disposing) {
                this.disposing = true;
                for (int i = this.pool.length - 1; i >= 0; --i) {
                    if (this.pool[i] == null || this.pool[i].isDisposing()) continue;
                    try {
                        this.pool[i].dispose();
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to dispose a " + this.pool[i].getClass().getSimpleName() + " at index " + i + ".", (Throwable)e);
                        continue;
                    }
                    finally {
                        this.pool[i] = null;
                    }
                }
                if (this.createdExecutor) {
                    ((ExecutorService)this.executor).shutdown();
                }
            }
        }
        this.disposed = true;
    }

    private IoProcessor<T> getProcessor(T session) {
        IoProcessor<T> processor = (IoProcessor<T>)((AbstractIoSession)session).getAttribute(PROCESSOR);
        if (processor == null) {
            processor = this.nextProcessor(session);
            ((AbstractIoSession)session).setAttributeIfAbsent(PROCESSOR, processor);
        }
        return processor;
    }

    private IoProcessor<T> nextProcessor(T session) {
        if (this.disposed) {
            throw new IllegalStateException("A disposed processor cannot be accessed.");
        }
        return this.pool[Math.abs((int)((AbstractIoSession)session).getId()) % this.pool.length];
    }
}

