/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.reqres;

import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.mina.filter.reqres.RequestTimeoutException;
import org.apache.mina.filter.reqres.Response;
import org.apache.mina.filter.reqres.ResponseType;

public class Request {
    private final Object id;
    private final Object message;
    private final long timeoutMillis;
    private volatile Runnable timeoutTask;
    private volatile ScheduledFuture<?> timeoutFuture;
    private final BlockingQueue<Object> responses;
    private volatile boolean endOfResponses;

    public Request(Object id, Object message, long timeoutMillis) {
        this(id, message, true, timeoutMillis);
    }

    public Request(Object id, Object message, boolean useResponseQueue, long timeoutMillis) {
        this(id, message, useResponseQueue, timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public Request(Object id, Object message, long timeout, TimeUnit unit) {
        this(id, message, true, timeout, unit);
    }

    public Request(Object id, Object message, boolean useResponseQueue, long timeout, TimeUnit unit) {
        if (id == null) {
            throw new IllegalArgumentException("id");
        }
        if (message == null) {
            throw new IllegalArgumentException("message");
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout: " + timeout + " (expected: 0+)");
        }
        if (timeout == 0L) {
            timeout = Long.MAX_VALUE;
        }
        if (unit == null) {
            throw new IllegalArgumentException("unit");
        }
        this.id = id;
        this.message = message;
        this.responses = useResponseQueue ? new LinkedBlockingQueue() : null;
        this.timeoutMillis = unit.toMillis(timeout);
    }

    public Object getId() {
        return this.id;
    }

    public Object getMessage() {
        return this.message;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public boolean isUseResponseQueue() {
        return this.responses != null;
    }

    public boolean hasResponse() {
        this.checkUseResponseQueue();
        return !this.responses.isEmpty();
    }

    public Response awaitResponse() throws RequestTimeoutException, InterruptedException {
        this.checkUseResponseQueue();
        this.chechEndOfResponses();
        return this.convertToResponse(this.responses.take());
    }

    public Response awaitResponse(long timeout, TimeUnit unit) throws RequestTimeoutException, InterruptedException {
        this.checkUseResponseQueue();
        this.chechEndOfResponses();
        return this.convertToResponse(this.responses.poll(timeout, unit));
    }

    private Response convertToResponse(Object o) {
        if (o instanceof Response) {
            return (Response)o;
        }
        if (o == null) {
            return null;
        }
        throw (RequestTimeoutException)o;
    }

    public Response awaitResponseUninterruptibly() throws RequestTimeoutException {
        while (true) {
            try {
                return this.awaitResponse();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void chechEndOfResponses() {
        if (this.responses != null && this.endOfResponses && this.responses.isEmpty()) {
            throw new NoSuchElementException("All responses has been retrieved already.");
        }
    }

    private void checkUseResponseQueue() {
        if (this.responses == null) {
            throw new UnsupportedOperationException("Response queue is not available; useResponseQueue is false.");
        }
    }

    void signal(Response response) {
        this.signal0(response);
        if (response.getType() != ResponseType.PARTIAL) {
            this.endOfResponses = true;
        }
    }

    void signal(RequestTimeoutException e) {
        this.signal0(e);
        this.endOfResponses = true;
    }

    private void signal0(Object answer) {
        if (this.responses != null) {
            this.responses.add(answer);
        }
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Request)) {
            return false;
        }
        Request that = (Request)o;
        return this.getId().equals(that.getId());
    }

    public String toString() {
        String timeout = this.getTimeoutMillis() == Long.MAX_VALUE ? "max" : String.valueOf(this.getTimeoutMillis());
        return "request: { id=" + this.getId() + ", timeout=" + timeout + ", message=" + this.getMessage() + " }";
    }

    Runnable getTimeoutTask() {
        return this.timeoutTask;
    }

    void setTimeoutTask(Runnable timeoutTask) {
        this.timeoutTask = timeoutTask;
    }

    ScheduledFuture<?> getTimeoutFuture() {
        return this.timeoutFuture;
    }

    void setTimeoutFuture(ScheduledFuture<?> timeoutFuture) {
        this.timeoutFuture = timeoutFuture;
    }
}

