/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.state;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.common.util.Tools;
import org.gatein.pc.api.InvalidPortletIdException;
import org.gatein.pc.api.NoSuchPortletException;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.StatefulPortletContext;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.pc.api.state.DestroyCloneFailure;
import org.gatein.pc.api.state.PropertyChange;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.pc.portlet.impl.state.StateConverterV0;
import org.gatein.pc.portlet.state.AbstractPropertyContext;
import org.gatein.pc.portlet.state.SimplePropertyMap;
import org.gatein.pc.portlet.state.producer.PortletState;
import org.gatein.pc.portlet.support.PortletSupport;
import org.gatein.pc.portlet.support.info.PortletInfoSupport;
import org.gatein.pc.test.portlet.state.ValueMapAssert;

public abstract class AbstractStatefulPortletInvokerTestCase
extends TestCase {
    public static final String PORTLET_ID = "/foo.PortletId";
    public static final String NON_EXISTING_PORTLET_ID = "/foo.NonExistingPortletId";
    public static final String INVALID_PORTLET_ID = "/foo.InvalidPortletId";
    protected final boolean persistLocally;

    protected AbstractStatefulPortletInvokerTestCase(boolean persistLocally) {
        this.persistLocally = persistLocally;
    }

    protected abstract PortletSupport getPortletSupport(PortletContext var1) throws PortletInvokerException;

    protected abstract Portlet getPortlet(PortletContext var1) throws PortletInvokerException;

    protected abstract String getPortletId(PortletContext var1) throws PortletInvokerException;

    protected abstract PortletContext createPOPRef(PortletInfoSupport var1) throws PortletInvokerException;

    protected abstract PortletContext createNonExistingPOPRef() throws PortletInvokerException;

    protected abstract PortletContext createInvalidPOPRef() throws PortletInvokerException;

    protected abstract PortletContext createLocalClone(PortletContext var1) throws Exception;

    protected abstract void destroyClone(PortletContext var1) throws Exception;

    protected abstract PortletContext createClone(PortletContext var1) throws PortletInvokerException;

    protected abstract PortletContext setProperties(PortletContext var1, PropertyChange[] var2) throws PortletInvokerException;

    protected abstract PropertyMap getProperties(PortletContext var1) throws PortletInvokerException;

    protected abstract PropertyMap getProperties(PortletContext var1, Set var2) throws PortletInvokerException;

    protected abstract List destroyClones(List var1) throws PortletInvokerException;

    protected abstract void assertNoExistingState();

    protected abstract void invoke(PortletInvocation var1) throws PortletInvokerException;

    protected abstract ActionInvocation createAction(PortletContext var1, AccessMode var2);

    protected abstract PortletContext getImplicitClonedRef(ActionInvocation var1);

    protected abstract PortletContext getModifiedPortletRef(ActionInvocation var1);

    protected abstract void addPreference(PortletContext var1, String var2, List<String> var3);

    protected abstract void addPreference(PortletContext var1, String var2, List<String> var3, Boolean var4);

    protected abstract PortletContext exportPortletContext(PortletContext var1) throws PortletInvokerException;

    protected abstract PortletContext importPortletContext(PortletContext var1) throws PortletInvokerException;

    protected final void assertCloneDoesNotExist(PortletContext ref) {
        if (this.persistLocally) {
            try {
                this.getProperties(ref);
                AbstractStatefulPortletInvokerTestCase.fail((String)"Was expecting a NoSuchPortletException to be thrown");
            }
            catch (NoSuchPortletException expected) {
            }
            catch (PortletInvokerException e) {
                AssertionFailedError afe = new AssertionFailedError();
                afe.initCause((Throwable)e);
                throw afe;
            }
        } else {
            try {
                this.getProperties(ref);
            }
            catch (PortletInvokerException e) {
                AssertionFailedError afe = new AssertionFailedError();
                afe.initCause((Throwable)e);
                throw afe;
            }
        }
    }

    protected final PortletContext createLocalCCPRef() throws Exception {
        PortletContext popCtx = this.createPOPRef();
        return this.createLocalClone(popCtx);
    }

    protected final PortletContext createNonExistingLocalCCPRef() throws Exception {
        PortletContext popRef = this.createPOPRef();
        PortletContext ccpRef = this.createLocalClone(popRef);
        this.destroyClone(ccpRef);
        return ccpRef;
    }

    protected final PortletContext createPOPRef() throws PortletInvokerException {
        PortletInfoSupport info = new PortletInfoSupport();
        return this.createPOPRef(info);
    }

    public void testCloneWithNullContext() throws Exception {
        try {
            this.createClone(null);
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertNoExistingState();
    }

    public void testCloneNonExistingPOP() throws Exception {
        PortletContext popCtx = this.createNonExistingPOPRef();
        try {
            this.createClone(popCtx);
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting an NoSuchPortletException");
        }
        catch (NoSuchPortletException noSuchPortletException) {
            // empty catch block
        }
        this.assertNoExistingState();
    }

    public void testCloneNonExistingCCP() throws Exception {
        PortletContext ccpCtx = this.createNonExistingLocalCCPRef();
        try {
            this.createClone(ccpCtx);
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting an NoSuchPortletException");
        }
        catch (NoSuchPortletException noSuchPortletException) {
            // empty catch block
        }
        this.assertNoExistingState();
    }

    public void testCloneInvalidPOP() throws Exception {
        PortletContext popCtx = this.createInvalidPOPRef();
        try {
            this.createClone(popCtx);
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting an InvalidPortletIdException");
        }
        catch (InvalidPortletIdException invalidPortletIdException) {
            // empty catch block
        }
        this.assertNoExistingState();
    }

    public void testClonePortlet() throws Exception {
        PortletInfoSupport info = new PortletInfoSupport();
        info.getMeta().setDisplayName("MyPortlet");
        PortletContext popCtx = this.createPOPRef(info);
        this.addPreference(popCtx, "abc", Arrays.asList("def"));
        PortletContext ccp1Ctx = this.createClone(popCtx);
        SimplePropertyMap expected = new SimplePropertyMap();
        expected.setProperty("abc", Arrays.asList("def"));
        PropertyMap ccp1Props = this.getProperties(ccp1Ctx);
        ValueMapAssert.assertEquals((PropertyMap)expected, ccp1Props);
        Portlet ccp1 = this.getPortlet(ccp1Ctx);
        LocalizedString abc = ccp1.getInfo().getMeta().getMetaValue("display-name");
        AbstractStatefulPortletInvokerTestCase.assertEquals((String)"MyPortlet", (String)abc.getString(Locale.ENGLISH, true));
        this._assertEquals(ccp1Ctx, ccp1.getContext());
        PropertyChange[] changes = new PropertyChange[]{PropertyChange.newUpdate((String)"ghi", Arrays.asList("jkl"))};
        ccp1Ctx = this.setProperties(ccp1Ctx, changes);
        PortletContext ccp2Ctx = this.createClone(ccp1Ctx);
        expected = new SimplePropertyMap();
        expected.setProperty("abc", Arrays.asList("def"));
        expected.setProperty("ghi", Arrays.asList("jkl"));
        PropertyMap ccp2Props = this.getProperties(ccp2Ctx);
        ValueMapAssert.assertEquals((PropertyMap)expected, ccp2Props);
        Portlet ccp2 = this.getPortlet(ccp2Ctx);
        LocalizedString def = ccp2.getInfo().getMeta().getMetaValue("display-name");
        AbstractStatefulPortletInvokerTestCase.assertEquals((String)"MyPortlet", (String)def.getString(Locale.ENGLISH, true));
    }

    public void testGetWithNullId() throws Exception {
        try {
            this.getPortlet(null);
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetNonExistingPOP() throws Exception {
        PortletContext pop = this.createNonExistingPOPRef();
        try {
            this.getPortlet(pop);
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting a NoSuchPortletException");
        }
        catch (NoSuchPortletException noSuchPortletException) {
            // empty catch block
        }
    }

    public void testGetNonExistingCCP() throws Exception {
        PortletContext ccpCtx = this.createNonExistingLocalCCPRef();
        try {
            this.getPortlet(ccpCtx);
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting a NoSuchPortletException");
        }
        catch (NoSuchPortletException noSuchPortletException) {
            // empty catch block
        }
    }

    public void testGetInvalidPOP() throws Exception {
        PortletContext popCtx = this.createInvalidPOPRef();
        try {
            this.getPortlet(popCtx);
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting an InvalidPortletIdException");
        }
        catch (InvalidPortletIdException invalidPortletIdException) {
            // empty catch block
        }
    }

    public void testDestroyWithNullId() throws Exception {
        try {
            this.destroyClones(null);
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDestroyPOP() throws Exception {
        PortletContext popCtx = this.createPOPRef();
        List failures = this.destroyClones(Collections.singletonList(popCtx));
        AbstractStatefulPortletInvokerTestCase.assertEquals((int)1, (int)failures.size());
        DestroyCloneFailure failure = (DestroyCloneFailure)failures.get(0);
        AbstractStatefulPortletInvokerTestCase.assertEquals((String)this.getPortletId(popCtx), (String)failure.getPortletId());
    }

    public void testDestroyCCP() throws Exception {
        PortletContext popCtx = this.createPOPRef();
        PortletContext ccpCtx = this.createClone(popCtx);
        List failures = this.destroyClones(Collections.singletonList(ccpCtx));
        AbstractStatefulPortletInvokerTestCase.assertEquals((int)0, (int)failures.size());
        this.assertNoExistingState();
    }

    public void testDestroyNonExistingCCP() throws Exception {
        PortletContext ccpCtx = this.createNonExistingLocalCCPRef();
        List failures = this.destroyClones(Collections.singletonList(ccpCtx));
        AbstractStatefulPortletInvokerTestCase.assertEquals((int)1, (int)failures.size());
        DestroyCloneFailure failure = (DestroyCloneFailure)failures.get(0);
        AbstractStatefulPortletInvokerTestCase.assertEquals((String)this.getPortletId(ccpCtx), (String)failure.getPortletId());
    }

    public void testGetPropertiesWithNullPortlet() throws Exception {
        try {
            this.getProperties(null);
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.getProperties(null, new HashSet());
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetNonExistingPOPProperties() throws Exception {
        PortletContext popCtx = this.createNonExistingPOPRef();
        try {
            this.getProperties(popCtx);
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting a NoSuchPortletException");
        }
        catch (NoSuchPortletException e) {
            // empty catch block
        }
        try {
            this.getProperties(popCtx, new HashSet());
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting a NoSuchPortletException");
        }
        catch (NoSuchPortletException noSuchPortletException) {
            // empty catch block
        }
    }

    public void testGetInvalidPOPProperties() throws Exception {
        PortletContext popCtx = this.createInvalidPOPRef();
        try {
            this.getProperties(popCtx);
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting an InvalidPortletIdException");
        }
        catch (InvalidPortletIdException e) {
            // empty catch block
        }
        try {
            this.getProperties(popCtx, new HashSet());
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting an InvalidPortletIdException");
        }
        catch (InvalidPortletIdException invalidPortletIdException) {
            // empty catch block
        }
    }

    public void testGetNonExistingCCPProperties() throws Exception {
        PortletContext ccpCtx = this.createNonExistingLocalCCPRef();
        try {
            this.getProperties(ccpCtx);
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting a NoSuchPortletException");
        }
        catch (NoSuchPortletException e) {
            // empty catch block
        }
        try {
            this.getProperties(ccpCtx, new HashSet());
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting a NoSuchPortletException");
        }
        catch (NoSuchPortletException noSuchPortletException) {
            // empty catch block
        }
    }

    public void testGetPOPWithNullKeys() throws Exception {
        PortletContext popCtx = this.createPOPRef();
        try {
            this.getProperties(popCtx, null);
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetCCPWithNullKeys() throws Exception {
        PortletContext ccpCtx = this.createLocalCCPRef();
        try {
            this.getProperties(ccpCtx, null);
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetPOPProperties() throws Exception {
        PortletInfoSupport info = new PortletInfoSupport();
        PortletContext popCtx = this.createPOPRef(info);
        this.addPreference(popCtx, "abc", Arrays.asList("def"));
        this.addPreference(popCtx, "ghi", Arrays.asList("jkl"), Boolean.TRUE);
        PropertyMap props = this.getProperties(popCtx);
        SimplePropertyMap expectedProps = new SimplePropertyMap();
        expectedProps.setProperty("abc", Arrays.asList("def"));
        expectedProps.setProperty("ghi", Arrays.asList("jkl"));
        ValueMapAssert.assertEquals((PropertyMap)expectedProps, props);
        props = this.getProperties(popCtx, Tools.toSet((Object[])new String[]{"abc", "mno"}));
        expectedProps = new SimplePropertyMap();
        expectedProps.setProperty("abc", Arrays.asList("def"));
        ValueMapAssert.assertEquals((PropertyMap)expectedProps, props);
    }

    public void testGetCCPProperties() throws Exception {
        PortletInfoSupport info = new PortletInfoSupport();
        PortletContext popCtx = this.createPOPRef(info);
        this.addPreference(popCtx, "abc", Arrays.asList("def"));
        this.addPreference(popCtx, "ghi", Arrays.asList("jkl"));
        this.addPreference(popCtx, "mno", Arrays.asList("pqr"), Boolean.TRUE);
        this.addPreference(popCtx, "stu", Arrays.asList("vwx"), Boolean.TRUE);
        PortletContext ccpCtx = this.createClone(popCtx);
        ccpCtx = this.setProperties(ccpCtx, new PropertyChange[]{PropertyChange.newUpdate((String)"abc", Arrays.asList("_def")), PropertyChange.newReset((String)"gho"), PropertyChange.newUpdate((String)"mno", Arrays.asList("_pqr")), PropertyChange.newReset((String)"stu")});
        PropertyMap props = this.getProperties(ccpCtx);
        SimplePropertyMap expectedProps = new SimplePropertyMap();
        expectedProps.setProperty("abc", Arrays.asList("_def"));
        expectedProps.setProperty("ghi", Arrays.asList("jkl"));
        expectedProps.setProperty("mno", Arrays.asList("pqr"));
        expectedProps.setProperty("stu", Arrays.asList("vwx"));
        ValueMapAssert.assertEquals((PropertyMap)expectedProps, props);
        props = this.getProperties(ccpCtx, Tools.toSet((Object[])new String[]{"abc", "mno", "yz"}));
        expectedProps = new SimplePropertyMap();
        expectedProps.setProperty("abc", Arrays.asList("_def"));
        expectedProps.setProperty("mno", Arrays.asList("pqr"));
        ValueMapAssert.assertEquals((PropertyMap)expectedProps, props);
    }

    public void testSetPropertiesWithNullId() throws Exception {
        try {
            this.setProperties(null, new PropertyChange[0]);
            AbstractStatefulPortletInvokerTestCase.fail((String)"Was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetPropertiesWithNullProperties() throws Exception {
        PortletContext ccpCtx = this.createLocalCCPRef();
        try {
            this.setProperties(ccpCtx, null);
            AbstractStatefulPortletInvokerTestCase.fail((String)"Was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetPOPProperties() throws Exception {
        PortletContext popCtx = this.createPOPRef();
        try {
            this.setProperties(popCtx, new PropertyChange[0]);
            AbstractStatefulPortletInvokerTestCase.fail((String)"Was expecting an InvalidPortletIdException");
        }
        catch (InvalidPortletIdException invalidPortletIdException) {
            // empty catch block
        }
    }

    public void testSetNonExistingCCPProperties() throws Exception {
        PortletContext ccpCtx = this.createNonExistingLocalCCPRef();
        try {
            this.setProperties(ccpCtx, new PropertyChange[0]);
            AbstractStatefulPortletInvokerTestCase.fail((String)"Was expecting a NoSuchPortletException");
        }
        catch (NoSuchPortletException noSuchPortletException) {
            // empty catch block
        }
    }

    public void testSetCCPProperties() throws Exception {
        PortletInfoSupport info = new PortletInfoSupport();
        PortletContext popCtx = this.createPOPRef(info);
        this.addPreference(popCtx, "override_update", Arrays.asList("override_update_portlet_value"));
        this.addPreference(popCtx, "override_reset", Arrays.asList("override_reset_portlet_value"));
        this.addPreference(popCtx, "override_create", Arrays.asList("override_create_portlet_value"));
        this.addPreference(popCtx, "readonly_create", Arrays.asList("readonly_create_portlet_value"), Boolean.TRUE);
        PortletContext ccpCtx = this.createClone(popCtx);
        ccpCtx = this.setProperties(ccpCtx, new PropertyChange[]{PropertyChange.newUpdate((String)"override_update", Arrays.asList("override_update_clone_value")), PropertyChange.newUpdate((String)"override_reset", Arrays.asList("override_reset_clone_value")), PropertyChange.newUpdate((String)"dynamic_update", Arrays.asList("dynamic_update_clone_value")), PropertyChange.newUpdate((String)"dynamic_reset", Arrays.asList("dynamic_reset_clone_value"))});
        SimplePropertyMap expectedProps = new SimplePropertyMap();
        expectedProps.setProperty("override_update", Arrays.asList("override_update_clone_value"));
        expectedProps.setProperty("override_reset", Arrays.asList("override_reset_clone_value"));
        expectedProps.setProperty("override_create", Arrays.asList("override_create_portlet_value"));
        expectedProps.setProperty("readonly_create", Arrays.asList("readonly_create_portlet_value"));
        expectedProps.setProperty("dynamic_update", Arrays.asList("dynamic_update_clone_value"));
        expectedProps.setProperty("dynamic_reset", Arrays.asList("dynamic_reset_clone_value"));
        PropertyMap ccpProps = this.getProperties(ccpCtx);
        ValueMapAssert.assertEquals((PropertyMap)expectedProps, ccpProps);
        PropertyChange[] changes = new PropertyChange[]{PropertyChange.newUpdate((String)"override_update", Arrays.asList("override_update_clone_value_2")), PropertyChange.newReset((String)"override_reset"), PropertyChange.newUpdate((String)"override_create", Arrays.asList("override_create_clone_value_2")), PropertyChange.newUpdate((String)"dynamic_update", Arrays.asList("dynamic_update_clone_value_2")), PropertyChange.newReset((String)"dynamic_reset"), PropertyChange.newUpdate((String)"dynamic_create", Arrays.asList("dynamic_create_clone_value_2")), PropertyChange.newUpdate((String)"readonly_create", Arrays.asList("readonly_create_clone_value_2"))};
        ccpCtx = this.setProperties(ccpCtx, changes);
        expectedProps.clear();
        expectedProps.setProperty("override_update", Arrays.asList("override_update_clone_value_2"));
        expectedProps.setProperty("override_create", Arrays.asList("override_create_clone_value_2"));
        expectedProps.setProperty("override_reset", Arrays.asList("override_reset_portlet_value"));
        expectedProps.setProperty("dynamic_update", Arrays.asList("dynamic_update_clone_value_2"));
        expectedProps.setProperty("dynamic_create", Arrays.asList("dynamic_create_clone_value_2"));
        expectedProps.setProperty("readonly_create", Arrays.asList("readonly_create_portlet_value"));
        ccpProps = this.getProperties(ccpCtx);
        ValueMapAssert.assertEquals((PropertyMap)expectedProps, ccpProps);
    }

    public void testInvokeCloneBeforeWritePOPWithUpdate() throws Exception {
        this.invokeCloneBeforeWriteWithUpdate(true);
    }

    public void testInvokeCloneBeforeWriteCCPWithUpdate() throws Exception {
        this.invokeCloneBeforeWriteWithUpdate(false);
    }

    public void invokeCloneBeforeWriteWithUpdate(boolean pop) throws Exception {
        PortletContext ctx;
        PortletSupport portletSupport;
        PortletContext popCtx;
        PortletInfoSupport info = new PortletInfoSupport();
        PortletSupport.InvocationHandler handler = new PortletSupport.InvocationHandler(){

            @Override
            public PortletInvocationResponse invoke(PortletInvocation invocation) {
                AbstractPropertyContext props = (AbstractPropertyContext)invocation.getAttribute("preferences");
                props.update(new PropertyChange[]{PropertyChange.newUpdate((String)"abc", Arrays.asList("_def"))});
                return null;
            }
        };
        if (pop) {
            popCtx = this.createPOPRef(info);
            portletSupport = this.getPortletSupport(popCtx);
            portletSupport.addHandler(handler);
            this.addPreference(popCtx, "abc", Arrays.asList("def"));
            ctx = popCtx;
        } else {
            PortletContext ccpCtx;
            popCtx = this.createPOPRef(info);
            portletSupport = this.getPortletSupport(popCtx);
            portletSupport.addHandler(handler);
            this.addPreference(popCtx, "abc", Arrays.asList("def"));
            ctx = ccpCtx = this.createClone(popCtx);
        }
        ActionInvocation invocation = this.createAction(ctx, AccessMode.CLONE_BEFORE_WRITE);
        this.invoke((PortletInvocation)invocation);
        PortletContext cloneRef = this.getImplicitClonedRef(invocation);
        AbstractStatefulPortletInvokerTestCase.assertNotNull((Object)cloneRef);
        PropertyMap blah = this.getProperties(cloneRef);
        SimplePropertyMap expectedProps = new SimplePropertyMap();
        expectedProps.setProperty("abc", Arrays.asList("_def"));
        ValueMapAssert.assertEquals((PropertyMap)expectedProps, blah);
        this.destroyClone(cloneRef);
        this.assertCloneDoesNotExist(cloneRef);
    }

    public void testInvokeReadOnlyWithUpdate() throws Exception {
        final Boolean[] ise = new Boolean[]{Boolean.FALSE};
        PortletInfoSupport info = new PortletInfoSupport();
        PortletSupport.InvocationHandler handler = new PortletSupport.InvocationHandler(){

            @Override
            public PortletInvocationResponse invoke(PortletInvocation invocation) {
                try {
                    AbstractPropertyContext props = (AbstractPropertyContext)invocation.getAttribute("preferences");
                    props.update(new PropertyChange[]{PropertyChange.newUpdate((String)"abc", Arrays.asList("_def"))});
                    return null;
                }
                catch (IllegalStateException e) {
                    ise[0] = Boolean.TRUE;
                    return null;
                }
            }
        };
        PortletContext popCtx = this.createPOPRef(info);
        PortletSupport portletSupport = this.getPortletSupport(popCtx);
        portletSupport.addHandler(handler);
        this.addPreference(popCtx, "abc", Arrays.asList("def"));
        ActionInvocation invocation = this.createAction(popCtx, AccessMode.READ_ONLY);
        this.invoke((PortletInvocation)invocation);
        AbstractStatefulPortletInvokerTestCase.assertEquals((Object)Boolean.TRUE, (Object)ise[0]);
    }

    public void testInvokeReadWriteWithUpdate() throws Exception {
        PortletInfoSupport info = new PortletInfoSupport();
        PortletSupport.InvocationHandler handler = new PortletSupport.InvocationHandler(){

            @Override
            public PortletInvocationResponse invoke(PortletInvocation invocation) {
                AbstractPropertyContext props = (AbstractPropertyContext)invocation.getAttribute("preferences");
                props.update(new PropertyChange[]{PropertyChange.newUpdate((String)"abc", Arrays.asList("_def"))});
                return null;
            }
        };
        PortletContext popCtx = this.createPOPRef(info);
        PortletSupport portletSupport = this.getPortletSupport(popCtx);
        portletSupport.addHandler(handler);
        this.addPreference(popCtx, "abc", Arrays.asList("def"));
        PortletContext ccpCtx = this.createClone(popCtx);
        ActionInvocation invocation = this.createAction(ccpCtx, AccessMode.READ_WRITE);
        this.invoke((PortletInvocation)invocation);
        ccpCtx = this.getModifiedPortletRef(invocation);
        AbstractStatefulPortletInvokerTestCase.assertNotNull((Object)ccpCtx);
        PropertyMap blah = this.getProperties(ccpCtx);
        SimplePropertyMap expectedProps = new SimplePropertyMap();
        expectedProps.setProperty("abc", Arrays.asList("_def"));
        ValueMapAssert.assertEquals((PropertyMap)expectedProps, blah);
    }

    private void _assertEquals(PortletContext expected, PortletContext actual) {
        if (expected == null) {
            AbstractStatefulPortletInvokerTestCase.assertNull((String)"Portlet context should be null", (Object)actual);
        } else {
            AbstractStatefulPortletInvokerTestCase.assertNotNull((String)("Portlet context should not be null but rather equals to " + expected), (Object)actual);
            AbstractStatefulPortletInvokerTestCase.assertEquals((String)expected.getId(), (String)actual.getId());
            Serializable expectedState = null;
            Serializable actualState = null;
            if (expected instanceof StatefulPortletContext) {
                expectedState = ((StatefulPortletContext)expected).getState();
            }
            if (actual instanceof StatefulPortletContext) {
                actualState = ((StatefulPortletContext)actual).getState();
            }
            if (expectedState == null) {
                AbstractStatefulPortletInvokerTestCase.assertNull((String)"Actual state should be null", (Object)actualState);
            } else {
                AbstractStatefulPortletInvokerTestCase.assertNotNull((String)"Actual state should be not null", (Object)actualState);
                AbstractStatefulPortletInvokerTestCase.assertTrue((boolean)expectedState.equals(actualState));
            }
        }
    }

    public void testExportNullPortletContext() throws Exception {
        try {
            this.exportPortletContext(null);
            AbstractStatefulPortletInvokerTestCase.fail((String)"Was expecting an illegal arguement exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertNoExistingState();
    }

    public void testExportsNonExisitngPOP() throws Exception {
        PortletContext popCTX = this.createNonExistingPOPRef();
        try {
            this.exportPortletContext(popCTX);
            AbstractStatefulPortletInvokerTestCase.fail((String)"Was expecting a NoSuchPortletException.");
        }
        catch (NoSuchPortletException noSuchPortletException) {
            // empty catch block
        }
        this.assertNoExistingState();
    }

    public void testExportNonExisitngCCP() throws Exception {
        PortletContext ccpCTX = this.createNonExistingLocalCCPRef();
        try {
            this.exportPortletContext(ccpCTX);
            AbstractStatefulPortletInvokerTestCase.fail((String)"Was expecting a NoSuchPortletException.");
        }
        catch (NoSuchPortletException noSuchPortletException) {
            // empty catch block
        }
        this.assertNoExistingState();
    }

    public void testExportInvalidPOP() throws Exception {
        PortletContext popCtx = this.createInvalidPOPRef();
        try {
            this.exportPortletContext(popCtx);
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting an InvalidPortletIdException");
        }
        catch (InvalidPortletIdException invalidPortletIdException) {
            // empty catch block
        }
        this.assertNoExistingState();
    }

    public void testExportPortlet() throws Exception {
        SimplePropertyMap expectedProperties = new SimplePropertyMap();
        expectedProperties.setProperty("abc", Arrays.asList("def"));
        PortletInfoSupport info = new PortletInfoSupport();
        info.getMeta().setDisplayName("MyPortlet");
        PortletContext popCtx = this.createPOPRef(info);
        PortletContext export0Ctx = this.exportPortletContext(popCtx);
        AbstractStatefulPortletInvokerTestCase.assertEquals((String)PORTLET_ID, (String)export0Ctx.getId());
        this.checkWithImportPortlet(export0Ctx, popCtx, (PropertyMap)new SimplePropertyMap());
        this.addPreference(popCtx, "abc", Arrays.asList("def"));
        PortletContext export1Ctx = this.exportPortletContext(popCtx);
        AbstractStatefulPortletInvokerTestCase.assertEquals((String)PORTLET_ID, (String)export1Ctx.getId());
        this.checkWithImportPortlet(export1Ctx, popCtx, (PropertyMap)expectedProperties);
        PortletContext ccp1Ctx = this.createClone(popCtx);
        PortletContext export2Ctx = this.exportPortletContext(ccp1Ctx);
        AbstractStatefulPortletInvokerTestCase.assertEquals((String)PORTLET_ID, (String)export2Ctx.getId());
        this.checkWithImportPortlet(export2Ctx, ccp1Ctx, (PropertyMap)expectedProperties);
        PortletContext ccp2Ctx = this.createClone(ccp1Ctx);
        PropertyChange[] propertyChanges = new PropertyChange[]{PropertyChange.newUpdate((String)"123", Arrays.asList("456"))};
        ccp1Ctx = this.setProperties(ccp1Ctx, propertyChanges);
        AbstractStatefulPortletInvokerTestCase.assertTrue((boolean)this.getProperties(ccp1Ctx).containsKey((Object)"123"));
        AbstractStatefulPortletInvokerTestCase.assertFalse((boolean)this.getProperties(export2Ctx).containsKey((Object)"123"));
        PortletContext export3Ctx = this.exportPortletContext(ccp2Ctx);
        AbstractStatefulPortletInvokerTestCase.assertEquals((String)PORTLET_ID, (String)export3Ctx.getId());
        this.checkWithImportPortlet(export3Ctx, ccp2Ctx, (PropertyMap)expectedProperties);
    }

    protected void checkWithImportPortlet(PortletContext exportedPortletContext, PortletContext originalPortletContext, PropertyMap expectedProperties) throws Exception {
        PortletContext importedPortletContext = this.importPortletContext(exportedPortletContext);
        Portlet importedPortlet = this.getPortlet(importedPortletContext);
        PortletContext portletContext = importedPortlet.getContext();
        AbstractStatefulPortletInvokerTestCase.assertEquals((Object)this.getPortlet(originalPortletContext).getInfo(), (Object)this.getPortlet(portletContext).getInfo());
        if (originalPortletContext instanceof StatefulPortletContext) {
            StatefulPortletContext statefulExpected = (StatefulPortletContext)originalPortletContext;
            AbstractStatefulPortletInvokerTestCase.assertTrue((boolean)(portletContext instanceof StatefulPortletContext));
            StatefulPortletContext statefulPortletContext = (StatefulPortletContext)portletContext;
            StateConverterV0 sc = new StateConverterV0();
            PortletState state = sc.unmarshall(PortletStateType.OPAQUE, (Serializable)((byte[])statefulPortletContext.getState()));
            PortletState expectedState = sc.unmarshall(PortletStateType.OPAQUE, (Serializable)((byte[])statefulExpected.getState()));
            AbstractStatefulPortletInvokerTestCase.assertEquals((String)expectedState.getPortletId(), (String)state.getPortletId());
            AbstractStatefulPortletInvokerTestCase.assertEquals((Object)expectedState.getProperties(), (Object)state.getProperties());
            AbstractStatefulPortletInvokerTestCase.assertEquals((Object)expectedState.getTerminationTime(), (Object)state.getTerminationTime());
            AbstractStatefulPortletInvokerTestCase.assertEquals(expectedState.getClass(), state.getClass());
        }
        PropertyMap properties = this.getProperties(portletContext);
        AbstractStatefulPortletInvokerTestCase.assertEquals((Object)expectedProperties, (Object)properties);
        AbstractStatefulPortletInvokerTestCase.assertEquals((Object)this.getProperties(originalPortletContext), (Object)properties);
    }

    public void testImportNullPortletContext() throws Exception {
        try {
            this.importPortletContext(null);
            AbstractStatefulPortletInvokerTestCase.fail((String)"Was expecting an illegal arguement exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertNoExistingState();
    }

    public void testImportsNonExisitngPOP() throws Exception {
        PortletContext popCTX = this.createNonExistingPOPRef();
        try {
            this.importPortletContext(popCTX);
            AbstractStatefulPortletInvokerTestCase.fail((String)"Was expecting a NoSuchPortletException.");
        }
        catch (NoSuchPortletException noSuchPortletException) {
            // empty catch block
        }
        this.assertNoExistingState();
    }

    public void testImportNonExisitngCCP() throws Exception {
        PortletContext ccpCTX = this.createNonExistingLocalCCPRef();
        try {
            this.importPortletContext(ccpCTX);
            AbstractStatefulPortletInvokerTestCase.fail((String)"Was expecting a NoSuchPortletException.");
        }
        catch (NoSuchPortletException noSuchPortletException) {
            // empty catch block
        }
        this.assertNoExistingState();
    }

    public void testImportInvalidPOP() throws Exception {
        PortletContext popCtx = this.createInvalidPOPRef();
        try {
            this.importPortletContext(popCtx);
            AbstractStatefulPortletInvokerTestCase.fail((String)"was expecting an InvalidPortletIdException");
        }
        catch (InvalidPortletIdException invalidPortletIdException) {
            // empty catch block
        }
        this.assertNoExistingState();
    }

    public void testImport() throws Exception {
        PortletContext popCtx = this.createPOPRef(new PortletInfoSupport());
        AbstractStatefulPortletInvokerTestCase.assertTrue((boolean)this.getProperties(popCtx).isEmpty());
        StateConverterV0 sc = new StateConverterV0();
        SimplePropertyMap propertyMap = new SimplePropertyMap();
        propertyMap.setProperty("test", Arrays.asList("123"));
        PortletState portletState = new PortletState(PORTLET_ID, (PropertyMap)propertyMap);
        byte[] stateBytes = (byte[])sc.marshall(PortletStateType.OPAQUE, portletState);
        StatefulPortletContext portletContext = StatefulPortletContext.create((String)PORTLET_ID, (PortletStateType)PortletStateType.OPAQUE, (Serializable)stateBytes);
        PortletContext importedPortletContext = this.importPortletContext((PortletContext)portletContext);
        AbstractStatefulPortletInvokerTestCase.assertEquals((Object)propertyMap, (Object)this.getProperties(importedPortletContext));
    }
}

