/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.state;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.PortletStatus;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.pc.api.state.PropertyChange;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.pc.portlet.impl.spi.AbstractInstanceContext;
import org.gatein.pc.portlet.impl.state.StateConverterV0;
import org.gatein.pc.portlet.impl.state.StateManagementPolicyService;
import org.gatein.pc.portlet.impl.state.producer.PortletStatePersistenceManagerService;
import org.gatein.pc.portlet.state.StateConverter;
import org.gatein.pc.portlet.state.StateManagementPolicy;
import org.gatein.pc.portlet.state.producer.PortletStatePersistenceManager;
import org.gatein.pc.portlet.state.producer.ProducerPortlet;
import org.gatein.pc.portlet.state.producer.ProducerPortletInvoker;
import org.gatein.pc.portlet.support.PortletInvokerSupport;
import org.gatein.pc.portlet.support.PortletSupport;
import org.gatein.pc.portlet.support.info.PortletInfoSupport;
import org.gatein.pc.test.portlet.state.AbstractStatefulPortletInvokerTestCase;
import org.gatein.pc.test.portlet.state.ActionContextImpl;

public abstract class ProducerStatefulPortletInvokerTestCase
extends AbstractStatefulPortletInvokerTestCase {
    protected ProducerPortletInvoker producer;
    protected PortletInvokerSupport container;
    protected PortletStatePersistenceManagerService persistenceManager;
    protected StateManagementPolicyService stateManagementPolicy;
    protected StateConverter stateConverter;

    protected ProducerStatefulPortletInvokerTestCase(boolean persistLocally) {
        super(persistLocally);
    }

    protected void setUp() throws Exception {
        this.producer = new ProducerPortletInvoker();
        this.container = new PortletInvokerSupport();
        this.persistenceManager = new PortletStatePersistenceManagerService();
        this.stateManagementPolicy = new StateManagementPolicyService();
        this.stateConverter = new StateConverterV0();
        this.stateManagementPolicy.setPersistLocally(this.persistLocally);
        this.producer.setNext((PortletInvoker)this.container);
        this.producer.setPersistenceManager((PortletStatePersistenceManager)this.persistenceManager);
        this.producer.setStateManagementPolicy((StateManagementPolicy)this.stateManagementPolicy);
        this.producer.setStateConverter(this.stateConverter);
    }

    @Override
    protected void assertNoExistingState() {
        ProducerStatefulPortletInvokerTestCase.assertEquals((int)0, (int)this.persistenceManager.getSize());
    }

    @Override
    protected PortletContext createPOPRef(PortletInfoSupport portletSupport) throws PortletInvokerException {
        this.container.addPortlet("/foo.PortletId", portletSupport);
        Portlet portlet = this.getSinglePOP();
        return portlet.getContext();
    }

    @Override
    protected PortletContext createNonExistingPOPRef() {
        this.container.addPortlet("/foo.NonExistingPortletId", new PortletInfoSupport());
        PortletContext popCtx = this.getSinglePOP().getContext();
        this.container.removePortlet("/foo.NonExistingPortletId");
        return popCtx;
    }

    @Override
    protected PortletContext createInvalidPOPRef() {
        this.container.addPortlet("/foo.InvalidPortletId", new PortletInfoSupport());
        PortletContext popCtx = this.getSinglePOP().getContext();
        this.container.setValid("/foo.InvalidPortletId", false);
        return popCtx;
    }

    @Override
    protected PortletContext createLocalClone(PortletContext portletRef) throws Exception {
        this.stateManagementPolicy.setPersistLocally(true);
        PortletContext cloneContext = this.producer.createClone(null, portletRef);
        this.stateManagementPolicy.setPersistLocally(this.persistLocally);
        return cloneContext;
    }

    @Override
    protected void addPreference(PortletContext popRef, String key, List<String> defaultValue) {
        this.container.getPortlet(popRef.getId()).addPreference(key, defaultValue);
    }

    @Override
    protected void addPreference(PortletContext popRef, String key, List<String> defaultValue, Boolean readOnly) {
        this.container.getPortlet(popRef.getId()).addPreference(key, defaultValue, readOnly);
    }

    @Override
    protected void destroyClone(PortletContext portletRef) throws Exception {
        ProducerStatefulPortletInvokerTestCase.assertEquals((Object)Collections.EMPTY_LIST, (Object)this.producer.destroyClones(Collections.singletonList(portletRef)));
    }

    @Override
    protected PortletContext createClone(PortletContext portletRef) throws PortletInvokerException {
        return this.producer.createClone(this.persistLocally ? null : PortletStateType.OPAQUE, portletRef);
    }

    @Override
    protected PortletContext setProperties(PortletContext portletRef, PropertyChange[] changes) throws PortletInvokerException {
        return this.producer.setProperties(portletRef, changes);
    }

    @Override
    protected PropertyMap getProperties(PortletContext portletRef) throws PortletInvokerException {
        return this.producer.getProperties(portletRef);
    }

    @Override
    protected PropertyMap getProperties(PortletContext portletRef, Set keys) throws PortletInvokerException {
        return this.producer.getProperties(portletRef, keys);
    }

    @Override
    protected List destroyClones(List portletRefs) throws PortletInvokerException {
        return this.producer.destroyClones(portletRefs);
    }

    @Override
    protected PortletSupport getPortletSupport(PortletContext portletRef) throws PortletInvokerException {
        Portlet portlet = this.producer.getPortlet(portletRef);
        if (portlet instanceof ProducerPortlet) {
            portlet = ((ProducerPortlet)portlet).getNext();
        }
        return (PortletSupport)portlet;
    }

    @Override
    protected Portlet getPortlet(PortletContext portletRef) throws PortletInvokerException {
        if (portletRef == null) {
            return this.producer.getPortlet(null);
        }
        return this.producer.getPortlet(portletRef);
    }

    @Override
    protected String getPortletId(PortletContext portletRef) throws PortletInvokerException {
        return portletRef.getId();
    }

    @Override
    protected void invoke(PortletInvocation invocation) throws PortletInvokerException {
        this.producer.invoke(invocation);
    }

    @Override
    protected ActionInvocation createAction(PortletContext portletRef, AccessMode accessMode) {
        ActionContextImpl actionCtx = new ActionContextImpl();
        AbstractInstanceContext instanceCtx = new AbstractInstanceContext("blah", accessMode){

            public PortletStateType<?> getStateType() {
                return ProducerStatefulPortletInvokerTestCase.this.persistLocally ? null : PortletStateType.OPAQUE;
            }
        };
        ActionInvocation action = new ActionInvocation((PortletInvocationContext)actionCtx);
        action.setInstanceContext((InstanceContext)instanceCtx);
        action.setTarget(portletRef);
        return action;
    }

    @Override
    protected PortletContext getImplicitClonedRef(ActionInvocation action) {
        AbstractInstanceContext instanceCtx = (AbstractInstanceContext)action.getInstanceContext();
        return instanceCtx.getClonedContext();
    }

    private Portlet getSinglePOP() {
        Set<Portlet> portlets = this.container.getPortlets();
        ProducerStatefulPortletInvokerTestCase.assertNotNull(portlets);
        ProducerStatefulPortletInvokerTestCase.assertEquals((int)1, (int)portlets.size());
        return portlets.iterator().next();
    }

    @Override
    protected PortletContext importPortletContext(PortletContext contextToImport) throws PortletInvokerException {
        return this.producer.importPortlet(PortletStateType.OPAQUE, contextToImport);
    }

    @Override
    protected PortletContext exportPortletContext(PortletContext originalPortletContext) throws PortletInvokerException {
        return this.producer.exportPortlet(PortletStateType.OPAQUE, originalPortletContext);
    }

    public void testGetStatus() throws Exception {
        PortletInfoSupport info = new PortletInfoSupport();
        info.getMeta().setDisplayName("MyPortlet");
        PortletContext popCtx = this.createPOPRef(info);
        ProducerStatefulPortletInvokerTestCase.assertEquals((Object)PortletStatus.OFFERED, (Object)this.producer.getStatus(popCtx));
        PortletContext ccp1Ctx = this.createClone(popCtx);
        ProducerStatefulPortletInvokerTestCase.assertEquals((Object)PortletStatus.MANAGED, (Object)this.producer.getStatus(ccp1Ctx));
        PortletContext ccp2Ctx = this.createClone(ccp1Ctx);
        ProducerStatefulPortletInvokerTestCase.assertEquals((Object)PortletStatus.MANAGED, (Object)this.producer.getStatus(ccp2Ctx));
        ProducerStatefulPortletInvokerTestCase.assertNull((Object)this.producer.getStatus(PortletContext.createPortletContext((String)"/foo.bar")));
    }
}

