/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.util.AbstractParser;
import org.jboss.as.connector.util.ParserException;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.CommonAdminObject;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.v10.CommonConnDef;
import org.jboss.jca.common.api.metadata.ds.v11.DataSource;
import org.jboss.jca.common.api.metadata.ds.v11.XaDataSource;
import org.jboss.jca.common.api.metadata.resourceadapter.v10.ResourceAdapter;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public abstract class CommonIronJacamarParser
extends AbstractParser {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    protected void parseConfigProperties(XMLExtendedStreamReader reader, Map<String, ModelNode> map) throws XMLStreamException, ParserException {
        String name = this.rawAttributeText((XMLStreamReader)reader, "name");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        String value = this.rawElementText((XMLStreamReader)reader);
        Constants.CONFIG_PROPERTY_VALUE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
        if (map.containsKey(name)) {
            throw new ParserException(bundle.unexpectedElement(Constants.CONFIG_PROPERTIES.getXmlName()));
        }
        map.put(name, operation);
    }

    protected void parseConnectionDefinitions(XMLExtendedStreamReader reader, Map<String, ModelNode> map, Map<String, HashMap<String, ModelNode>> configMap, boolean isXa) throws XMLStreamException, ParserException, ValidateException {
        ModelNode connectionDefinitionNode = new ModelNode();
        connectionDefinitionNode.get("operation").set("add");
        String poolName = null;
        String jndiName = null;
        int attributeSize = reader.getAttributeCount();
        boolean poolDefined = Boolean.FALSE;
        block21: for (int i = 0; i < attributeSize; ++i) {
            CommonConnDef.Attribute attribute = CommonConnDef.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENABLED.getXmlName());
                    if (value == null) continue block21;
                    Constants.ENABLED.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block21;
                }
                case JNDI_NAME: {
                    jndiName = this.rawAttributeText((XMLStreamReader)reader, Constants.JNDINAME.getXmlName());
                    if (jndiName == null) continue block21;
                    Constants.JNDINAME.parseAndSetParameter(jndiName, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block21;
                }
                case POOL_NAME: {
                    poolName = this.rawAttributeText((XMLStreamReader)reader, "pool-name");
                    continue block21;
                }
                case USE_JAVA_CONTEXT: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_JAVA_CONTEXT.getXmlName());
                    if (value == null) continue block21;
                    Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block21;
                }
                case USE_CCM: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_CCM.getXmlName());
                    if (value == null) continue block21;
                    Constants.USE_CCM.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block21;
                }
                case CLASS_NAME: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.CLASS_NAME.getXmlName());
                    if (value == null) continue block21;
                    Constants.CLASS_NAME.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block21;
                }
            }
        }
        if (poolName == null || poolName.trim().equals("")) {
            if (jndiName != null && jndiName.trim().length() != 0) {
                poolName = jndiName.contains("/") ? jndiName.substring(jndiName.lastIndexOf("/") + 1) : jndiName.substring(jndiName.lastIndexOf(":") + 1);
            } else {
                throw new ParserException(bundle.missingValue(Constants.JNDINAME.getXmlName()));
            }
        }
        while (reader.hasNext()) {
            block8 : switch (reader.nextTag()) {
                case 2: {
                    if (ResourceAdapter.Tag.forName((String)reader.getLocalName()) == ResourceAdapter.Tag.CONNECTION_DEFINITION) {
                        map.put(poolName, connectionDefinitionNode);
                        return;
                    }
                    if (CommonConnDef.Tag.forName((String)reader.getLocalName()) != CommonConnDef.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonConnDef.Tag.forName((String)reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            if (!configMap.containsKey(poolName)) {
                                configMap.put(poolName, new HashMap(0));
                            }
                            this.parseConfigProperties(reader, (Map<String, ModelNode>)configMap.get(poolName));
                            break block8;
                        }
                        case SECURITY: {
                            this.parseSecuritySettings(reader, connectionDefinitionNode);
                            break block8;
                        }
                        case TIMEOUT: {
                            this.parseTimeOut(reader, isXa, connectionDefinitionNode);
                            break block8;
                        }
                        case VALIDATION: {
                            this.parseValidation(reader, connectionDefinitionNode);
                            break block8;
                        }
                        case XA_POOL: {
                            if (!isXa) {
                                throw new ParserException(bundle.unexpectedElement(CommonConnDef.Tag.XA_POOL.name()));
                            }
                            if (poolDefined) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            this.parseXaPool(reader, connectionDefinitionNode);
                            poolDefined = true;
                            break block8;
                        }
                        case POOL: {
                            if (isXa) {
                                throw new ParserException(bundle.unexpectedElement(CommonConnDef.Tag.POOL.name()));
                            }
                            if (poolDefined) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            this.parsePool(reader, connectionDefinitionNode);
                            poolDefined = true;
                            break block8;
                        }
                        case RECOVERY: {
                            this.parseRecovery(reader, connectionDefinitionNode);
                            break block8;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseValidation(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException, ParserException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (CommonConnDef.Tag.forName((String)reader.getLocalName()) == CommonConnDef.Tag.VALIDATION) {
                        return;
                    }
                    if (CommonValidation.Tag.forName((String)reader.getLocalName()) != CommonValidation.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonValidation.Tag.forName((String)reader.getLocalName())) {
                        case BACKGROUND_VALIDATION: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case BACKGROUND_VALIDATION_MILLIS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USE_FAST_FAIL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseTimeOut(XMLExtendedStreamReader reader, Boolean isXa, ModelNode node) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (CommonConnDef.Tag.forName((String)reader.getLocalName()) == CommonConnDef.Tag.TIMEOUT) {
                        return;
                    }
                    if (CommonTimeOut.Tag.forName((String)reader.getLocalName()) != CommonTimeOut.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonTimeOut.Tag.forName((String)reader.getLocalName())) {
                        case ALLOCATION_RETRY: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.ALLOCATION_RETRY.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case ALLOCATION_RETRY_WAIT_MILLIS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.ALLOCATION_RETRY_WAIT_MILLIS.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case BLOCKING_TIMEOUT_MILLIS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case IDLE_TIMEOUT_MINUTES: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case XA_RESOURCE_TIMEOUT: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.XA_RESOURCE_TIMEOUT.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected void parseAdminObjects(XMLExtendedStreamReader reader, Map<String, ModelNode> map, Map<String, HashMap<String, ModelNode>> configMap) throws XMLStreamException, ParserException, ValidateException {
        ModelNode adminObjectNode = new ModelNode();
        adminObjectNode.get("operation").set("add");
        int attributeSize = reader.getAttributeCount();
        String poolName = null;
        String jndiName = null;
        block14: for (int i = 0; i < attributeSize; ++i) {
            CommonAdminObject.Attribute attribute = CommonAdminObject.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENABLED.getXmlName());
                    if (value == null) continue block14;
                    Constants.ENABLED.parseAndSetParameter(value, adminObjectNode, (XMLStreamReader)reader);
                    continue block14;
                }
                case JNDI_NAME: {
                    jndiName = this.rawAttributeText((XMLStreamReader)reader, Constants.JNDINAME.getXmlName());
                    if (jndiName == null) continue block14;
                    Constants.JNDINAME.parseAndSetParameter(jndiName, adminObjectNode, (XMLStreamReader)reader);
                    continue block14;
                }
                case POOL_NAME: {
                    poolName = this.rawAttributeText((XMLStreamReader)reader, "pool-name");
                    continue block14;
                }
                case USE_JAVA_CONTEXT: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_JAVA_CONTEXT.getXmlName());
                    if (value == null) continue block14;
                    Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, adminObjectNode, (XMLStreamReader)reader);
                    continue block14;
                }
                case CLASS_NAME: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.CLASS_NAME.getXmlName());
                    if (value == null) continue block14;
                    Constants.CLASS_NAME.parseAndSetParameter(value, adminObjectNode, (XMLStreamReader)reader);
                    continue block14;
                }
                default: {
                    throw new ParserException(bundle.unexpectedAttribute(attribute.getLocalName(), reader.getLocalName()));
                }
            }
        }
        if (poolName == null || poolName.trim().equals("")) {
            if (jndiName != null && jndiName.trim().length() != 0) {
                poolName = jndiName.contains("/") ? jndiName.substring(jndiName.lastIndexOf("/") + 1) : jndiName.substring(jndiName.lastIndexOf(":") + 1);
            } else {
                throw new ParserException(bundle.missingValue(Constants.JNDINAME.getXmlName()));
            }
        }
        while (reader.hasNext()) {
            block7 : switch (reader.nextTag()) {
                case 2: {
                    if (ResourceAdapter.Tag.forName((String)reader.getLocalName()) == ResourceAdapter.Tag.ADMIN_OBJECT) {
                        map.put(poolName, adminObjectNode);
                        return;
                    }
                    if (CommonAdminObject.Tag.forName((String)reader.getLocalName()) != CommonAdminObject.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonAdminObject.Tag.forName((String)reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            if (!configMap.containsKey(poolName)) {
                                configMap.put(poolName, new HashMap(0));
                            }
                            this.parseConfigProperties(reader, (Map<String, ModelNode>)configMap.get(poolName));
                            break block7;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected void parseXaPool(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) == XaDataSource.Tag.XA_POOL) {
                        return;
                    }
                    if (CommonXaPool.Tag.forName((String)reader.getLocalName()) != CommonXaPool.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonXaPool.Tag.forName((String)reader.getLocalName())) {
                        case MAX_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case PREFILL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case FLUSH_STRATEGY: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case INTERLEAVING: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            value = value == null ? "true" : value;
                            Constants.INTERLEAVING.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case IS_SAME_RM_OVERRIDE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.SAME_RM_OVERRIDE.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case NO_TX_SEPARATE_POOLS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            value = value == null ? "true" : value;
                            Constants.NOTXSEPARATEPOOL.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case PAD_XID: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.PAD_XID.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case WRAP_XA_RESOURCE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.WRAP_XA_RESOURCE.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected void parsePool(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.POOL) {
                        return;
                    }
                    if (CommonPool.Tag.forName((String)reader.getLocalName()) != CommonPool.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonPool.Tag.forName((String)reader.getLocalName())) {
                        case MAX_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case PREFILL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case FLUSH_STRATEGY: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected void parseRecovery(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException, ParserException, ValidateException {
        block11: for (Recovery.Attribute attribute : Recovery.Attribute.values()) {
            switch (attribute) {
                case NO_RECOVERY: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.NO_RECOVERY.getXmlName());
                    if (value == null) continue block11;
                    Constants.NO_RECOVERY.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block11;
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.nextTag()) {
                case 2: {
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) == XaDataSource.Tag.RECOVERY) {
                        return;
                    }
                    if (Recovery.Tag.forName((String)reader.getLocalName()) != Recovery.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    Recovery.Tag tag = Recovery.Tag.forName((String)reader.getLocalName());
                    switch (tag) {
                        case RECOVER_CREDENTIAL: {
                            this.parseRecoveryCredential(reader, node);
                            break block3;
                        }
                        case RECOVER_PLUGIN: {
                            this.parseExtension(reader, tag.getLocalName(), node, Constants.RECOVERLUGIN_CLASSNAME, Constants.RECOVERLUGIN_PROPERTIES);
                            break block3;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseSecuritySettings(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException, ParserException, ValidateException {
        boolean securtyDomainMatched = false;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY) {
                        return;
                    }
                    if (CommonSecurity.Tag.forName((String)reader.getLocalName()) != CommonSecurity.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonSecurity.Tag.forName((String)reader.getLocalName())) {
                        case SECURITY_DOMAIN: {
                            if (securtyDomainMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.SECURITY_DOMAIN.getXmlName()));
                            }
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.SECURITY_DOMAIN.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            securtyDomainMatched = true;
                            break block0;
                        }
                        case SECURITY_DOMAIN_AND_APPLICATION: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.SECURITY_DOMAIN_AND_APPLICATION.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case APPLICATION: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            value = value == null ? "true" : value;
                            Constants.APPLICATION.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseRecoveryCredential(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY || Recovery.Tag.forName((String)reader.getLocalName()) == Recovery.Tag.RECOVER_CREDENTIAL) {
                        return;
                    }
                    if (Credential.Tag.forName((String)reader.getLocalName()) != Credential.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Credential.Tag.forName((String)reader.getLocalName())) {
                        case PASSWORD: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_PASSWORD.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USER_NAME: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_USERNAME.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_SECURITY_DOMAIN.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }
}

