/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.impl.backing;

import java.io.Serializable;
import java.util.Set;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.PassivationManager;
import org.jboss.as.ejb3.cache.impl.backing.SerializationGroupMemberImpl;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryFactory;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStore;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStoreConfig;
import org.jboss.as.ejb3.cache.spi.GroupAwareBackingCache;
import org.jboss.as.ejb3.cache.spi.GroupCompatibilityChecker;
import org.jboss.as.ejb3.cache.spi.PassivatingBackingCache;
import org.jboss.as.ejb3.cache.spi.ReplicationPassivationManager;
import org.jboss.as.ejb3.cache.spi.SerializationGroup;
import org.jboss.as.ejb3.cache.spi.SerializationGroupMember;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.ejb.client.Affinity;
import org.jboss.logging.Logger;
import org.jboss.marshalling.MarshallingConfiguration;

public class SerializationGroupMemberContainer<K extends Serializable, V extends Cacheable<K>, G extends Serializable>
implements BackingCacheEntryFactory<K, V, SerializationGroupMember<K, V, G>>,
ReplicationPassivationManager<K, SerializationGroupMember<K, V, G>>,
BackingCacheEntryStore<K, V, SerializationGroupMember<K, V, G>> {
    private static final Logger log = Logger.getLogger(SerializationGroupMemberContainer.class);
    private final PassivationManager<K, V> passivationManager;
    private final boolean passivateEventsOnReplicate;
    private volatile BackingCacheEntryStore<K, V, SerializationGroupMember<K, V, G>> store;
    private volatile GroupAwareBackingCache<K, V, G, SerializationGroupMember<K, V, G>> delegate;
    private final PassivatingBackingCache<G, Cacheable<G>, SerializationGroup<K, V, G>> groupCache;

    public SerializationGroupMemberContainer(PassivationManager<K, V> passivationManager, PassivatingBackingCache<G, Cacheable<G>, SerializationGroup<K, V, G>> groupCache, BackingCacheEntryStoreConfig config) {
        this.passivationManager = passivationManager;
        this.groupCache = groupCache;
        this.passivateEventsOnReplicate = config.isPassivateEventsOnReplicate();
    }

    public void setBackingCache(GroupAwareBackingCache<K, V, G, SerializationGroupMember<K, V, G>> delegate) {
        this.delegate = delegate;
    }

    public void setBackingCacheEntryStore(BackingCacheEntryStore<K, V, SerializationGroupMember<K, V, G>> store) {
        this.store = store;
    }

    @Override
    public K createIdentifier() {
        return (K)((Serializable)this.store.createIdentifier());
    }

    @Override
    public Affinity getStrictAffinity() {
        return this.store.getStrictAffinity();
    }

    @Override
    public Affinity getWeakAffinity(K key) {
        return this.store.getWeakAffinity(key);
    }

    @Override
    public boolean hasAffinity(K key) {
        return this.store.hasAffinity(key);
    }

    public int getCurrentMarshallingVersion() {
        return this.passivationManager.getCurrentMarshallingVersion();
    }

    public MarshallingConfiguration getMarshallingConfiguration(int version) {
        return this.passivationManager.getMarshallingConfiguration(version);
    }

    @Override
    public SerializationGroupMember<K, V, G> createEntry(V item) {
        return new SerializationGroupMemberImpl<K, V, G>(item, this.delegate);
    }

    @Override
    public void destroyEntry(SerializationGroupMember<K, V, G> entry) {
        SerializationGroup<Serializable, V, G> group = entry.getGroup();
        if (group != null) {
            group.removeMember((Serializable)entry.getId());
            if (group.size() == 0) {
                this.groupCache.remove(group.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postActivate(SerializationGroupMember<K, V, G> entry) {
        log.tracef("postActivate(%s)", entry);
        SerializationGroup group = entry.getGroup();
        if (group == null && entry.getGroupId() != null) {
            group = (SerializationGroup)this.groupCache.get(entry.getGroupId());
        }
        if (group != null) {
            group.lock();
            try {
                entry.setGroup(group);
                entry.setUnderlyingItem(group.getMemberObject((Serializable)entry.getId()));
                group.addActive(entry);
            }
            finally {
                group.unlock();
            }
        }
        if (entry.isPrePassivated()) {
            this.passivationManager.postActivate(entry.getUnderlyingItem());
            entry.setPrePassivated(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prePassivate(SerializationGroupMember<K, V, G> entry) {
        SerializationGroup<Serializable, V, G> group;
        log.tracef("prePassivate(%s)", entry);
        if (!entry.isPrePassivated()) {
            this.passivationManager.prePassivate(entry.getUnderlyingItem());
        }
        if ((group = entry.getGroup()) != null) {
            if (!group.tryLock()) {
                throw EjbMessages.MESSAGES.couldNotObtainLockForGroup(((Serializable)group.getId()).toString(), entry.toString());
            }
            try {
                group.removeActive((Serializable)entry.getId());
                if (group.getInUseCount() == 0) {
                    this.groupCache.passivate(group.getId());
                } else {
                    log.tracef("Group %s has %d in-use members; not passivating serialization group %s", group, (Object)group.getInUseCount(), entry);
                }
                entry.setGroup(null);
            }
            finally {
                group.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preReplicate(SerializationGroupMember<K, V, G> entry) {
        SerializationGroup<Serializable, V, G> group;
        log.tracef("preReplicate(%s)", entry);
        if (!entry.isPreReplicated()) {
            if (this.passivateEventsOnReplicate) {
                this.passivationManager.prePassivate(entry.getUnderlyingItem());
            }
            entry.setPreReplicated(true);
        }
        if ((group = entry.getGroup()) != null) {
            group.lock();
            try {
                group.removeActive((Serializable)entry.getId());
                try {
                    if (group.getInUseCount() == 0) {
                        group.getGroupCache().release((Serializable)group.getId());
                        group.setGroupModified(false);
                    }
                }
                finally {
                    group.addActive(entry);
                }
                entry.setGroup(null);
            }
            finally {
                group.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postReplicate(SerializationGroupMember<K, V, G> entry) {
        log.tracef("postReplicate(%s)", entry);
        SerializationGroup group = entry.getGroup();
        if (group == null && entry.getGroupId() != null) {
            group = (SerializationGroup)this.groupCache.get(entry.getGroupId());
        }
        if (group != null) {
            group.lock();
            try {
                entry.setGroup(group);
                entry.setUnderlyingItem(group.getMemberObject((Serializable)entry.getId()));
                group.addActive(entry);
            }
            finally {
                group.unlock();
            }
        }
        if (entry.isPreReplicated()) {
            if (this.passivateEventsOnReplicate) {
                this.passivationManager.postActivate(entry.getUnderlyingItem());
            }
            entry.setPreReplicated(false);
        }
    }

    @Override
    public void update(SerializationGroupMember<K, V, G> entry, boolean modified) {
        this.store.update(entry, modified);
    }

    @Override
    public boolean isClustered() {
        return this.groupCache.isClustered();
    }

    @Override
    public SerializationGroupMember<K, V, G> get(K key, boolean lock) {
        SerializationGroupMember<K, V, G> entry = this.store.get(key, lock);
        if (entry != null) {
            entry.setPassivatingCache(this.delegate);
        }
        return entry;
    }

    @Override
    public void passivate(SerializationGroupMember<K, V, G> entry) {
        this.store.passivate(entry);
    }

    @Override
    public Set<K> insert(SerializationGroupMember<K, V, G> entry) {
        return this.store.insert(entry);
    }

    @Override
    public SerializationGroupMember<K, V, G> remove(K key) {
        return this.store.remove(key);
    }

    @Override
    public void start() {
        this.store.start();
    }

    @Override
    public void stop() {
        this.store.stop();
    }

    @Override
    public BackingCacheEntryStoreConfig getConfig() {
        return this.store.getConfig();
    }

    @Override
    public StatefulTimeoutInfo getTimeout() {
        return this.store.getTimeout();
    }

    public boolean isCompatibleWith(SerializationGroup<K, V, G> group) {
        PassivatingBackingCache<G, Cacheable<G>, SerializationGroup<K, V, G>> otherCache = group.getGroupCache();
        if (otherCache != null) {
            return this.store.isCompatibleWith(otherCache.getCompatibilityChecker());
        }
        return false;
    }

    @Override
    public boolean isCompatibleWith(GroupCompatibilityChecker other) {
        return this.store.isCompatibleWith(other);
    }
}

