/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.Timer;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.component.EjbComponentInstance;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.entity.WrappedRemoteException;
import org.jboss.as.ejb3.context.EntityContextImpl;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.naming.ManagedReference;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

public class EntityBeanComponentInstance
extends EjbComponentInstance {
    private volatile Object primaryKey;
    private volatile EntityContextImpl entityContext;
    private volatile boolean removed = false;
    private volatile boolean synchronizeRegistered;
    private volatile boolean reloadRequired = false;
    private final Interceptor ejbStore;
    private final Interceptor ejbActivate;
    private final Interceptor ejbLoad;
    private final Interceptor ejbPassivate;
    private final Interceptor unsetEntityContext;

    protected EntityBeanComponentInstance(BasicComponent component, AtomicReference<ManagedReference> instanceReference, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors) {
        super(component, instanceReference, preDestroyInterceptor, methodInterceptors);
        EntityBeanComponent ejbComponent = (EntityBeanComponent)component;
        this.ejbStore = ejbComponent.createInterceptor(ejbComponent.getEjbStore());
        this.ejbActivate = ejbComponent.createInterceptor(ejbComponent.getEjbActivate());
        this.ejbLoad = ejbComponent.createInterceptor(ejbComponent.getEjbLoad());
        this.ejbPassivate = ejbComponent.createInterceptor(ejbComponent.getEjbPassivate());
        this.unsetEntityContext = ejbComponent.createInterceptor(ejbComponent.getUnsetEntityContext());
    }

    @Override
    public EntityBeanComponent getComponent() {
        return (EntityBeanComponent)super.getComponent();
    }

    public EntityBean getInstance() {
        return (EntityBean)super.getInstance();
    }

    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    public void reload() {
        try {
            EntityBeanComponent component = this.getComponent();
            InterceptorContext loadContext = this.prepareInterceptorContext();
            loadContext.putPrivateData(InvocationType.class, (Object)InvocationType.ENTITY_EJB_EJB_LOAD);
            loadContext.setMethod(component.getEjbLoadMethod());
            this.ejbLoad.processInvocation(loadContext);
            this.reloadRequired = false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isReloadRequired() {
        return this.reloadRequired;
    }

    public void setReloadRequired(boolean reloadRequired) {
        this.reloadRequired = reloadRequired;
    }

    @Override
    public void discard() {
        if (!this.isDiscarded()) {
            this.getComponent().getCache().discard(this);
            this.primaryKey = null;
        }
        super.discard();
    }

    protected void preDestroy() {
        try {
            this.invokeUnsetEntityContext();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void invokeUnsetEntityContext() throws Exception {
        InterceptorContext context = this.prepareInterceptorContext();
        EntityBeanComponent component = this.getComponent();
        context.setMethod(component.getUnsetEntityContextMethod());
        context.putPrivateData(InvocationType.class, (Object)InvocationType.UNSET_ENTITY_CONTEXT);
        this.unsetEntityContext.processInvocation(context);
    }

    public synchronized void associate(Object primaryKey) {
        this.primaryKey = primaryKey;
        try {
            InterceptorContext context = this.prepareInterceptorContext();
            EntityBeanComponent component = this.getComponent();
            Method ejbActivateMethod = component.getEjbActivateMethod();
            context.setMethod(ejbActivateMethod);
            context.putPrivateData(InvocationType.class, (Object)InvocationType.ENTITY_EJB_ACTIVATE);
            this.ejbActivate.processInvocation(context);
            InterceptorContext loadContext = this.prepareInterceptorContext();
            loadContext.putPrivateData(InvocationType.class, (Object)InvocationType.ENTITY_EJB_EJB_LOAD);
            loadContext.setMethod(component.getEjbLoadMethod());
            this.ejbLoad.processInvocation(loadContext);
        }
        catch (RemoteException e) {
            throw new WrappedRemoteException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void store() {
        try {
            if (!this.removed) {
                this.invokeEjbStore();
            }
        }
        catch (RemoteException e) {
            throw new WrappedRemoteException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void invokeEjbStore() throws Exception {
        InterceptorContext context = this.prepareInterceptorContext();
        EntityBeanComponent component = this.getComponent();
        context.setMethod(component.getEjbStoreMethod());
        this.ejbStore.processInvocation(context);
    }

    public synchronized void passivate() {
        try {
            if (!this.removed) {
                InterceptorContext context = this.prepareInterceptorContext();
                EntityBeanComponent component = this.getComponent();
                context.setMethod(component.getEjbPassivateMethod());
                context.putPrivateData(InvocationType.class, (Object)InvocationType.ENTITY_EJB_PASSIVATE);
                this.ejbPassivate.processInvocation(context);
            }
            this.primaryKey = null;
            this.removed = false;
        }
        catch (RemoteException e) {
            throw new WrappedRemoteException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setupContext(InterceptorContext interceptorContext) {
        InvocationType invocationType = (InvocationType)interceptorContext.getPrivateData(InvocationType.class);
        try {
            interceptorContext.putPrivateData(InvocationType.class, (Object)InvocationType.SET_ENTITY_CONTEXT);
            EntityContextImpl entityContext = new EntityContextImpl(this);
            this.setEjbContext(entityContext);
            this.getInstance().setEntityContext((EntityContext)entityContext);
        }
        catch (RemoteException e) {
            throw new WrappedRemoteException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            interceptorContext.putPrivateData(InvocationType.class, (Object)invocationType);
        }
    }

    @Override
    public EntityContextImpl getEjbContext() {
        return this.entityContext;
    }

    protected void setEjbContext(EntityContextImpl entityContext) {
        this.entityContext = entityContext;
    }

    public EJBObject getEjbObject() {
        Object pk = this.getPrimaryKey();
        if (pk == null) {
            throw EjbLogger.EJB3_LOGGER.cannotCallGetEjbObjectBeforePrimaryKeyAssociation();
        }
        return this.getComponent().getEJBObject(pk);
    }

    public EJBLocalObject getEjbLocalObject() {
        Object pk = this.getPrimaryKey();
        if (pk == null) {
            throw EjbLogger.EJB3_LOGGER.cannotCallGetEjbLocalObjectBeforePrimaryKeyAssociation();
        }
        return this.getComponent().getEJBLocalObject(pk);
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public synchronized void setSynchronizationRegistered(boolean synchronizeRegistered) {
        this.synchronizeRegistered = synchronizeRegistered;
    }

    public synchronized boolean isSynchronizeRegistered() {
        return this.synchronizeRegistered;
    }

    protected void clearPrimaryKey() {
        this.primaryKey = null;
    }

    public void removeAllTimers() {
        for (Timer timer : this.getComponent().getTimerService().getTimers()) {
            TimerImpl timerImpl;
            if (!(timer instanceof TimerImpl) || (timerImpl = (TimerImpl)timer).getPrimaryKey() == null || !timerImpl.getPrimaryKey().equals(this.getPrimaryKey())) continue;
            timer.cancel();
        }
    }
}

