/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity.interceptors;

import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ComponentInstanceInterceptorFactory;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class EntityBeanReentrancyInterceptor
implements Interceptor {
    private volatile boolean invocationInProgress = false;
    public static final InterceptorFactory FACTORY = new ComponentInstanceInterceptorFactory(){

        protected Interceptor create(Component component, InterceptorFactoryContext context) {
            return new EntityBeanReentrancyInterceptor();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        if (this.invocationInProgress) {
            throw EjbMessages.MESSAGES.failToReacquireLockForNonReentrant((ComponentInstance)context.getPrivateData(ComponentInstance.class));
        }
        this.invocationInProgress = true;
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            this.invocationInProgress = false;
        }
    }
}

