/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.osgi.resolver.XAttachmentSupport;
import org.jboss.osgi.resolver.XAttributeSupport;
import org.jboss.osgi.resolver.XDirectiveSupport;
import org.jboss.osgi.resolver.XElement;

class AbstractElement
implements XElement {
    private String name;

    AbstractElement(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    static class DirectiveSupporter
    implements XDirectiveSupport {
        private Map<String, String> directives;

        DirectiveSupporter(Map<String, String> directives) {
            this.directives = directives;
        }

        public String getDirective(String key) {
            return this.directives != null ? this.directives.get(key) : null;
        }

        public Map<String, String> getDirectives() {
            return Collections.unmodifiableMap(this.directives);
        }
    }

    static class AttributeSupporter
    implements XAttributeSupport {
        private Map<String, Object> attributes;

        AttributeSupporter(Map<String, Object> attributes) {
            this.attributes = attributes;
        }

        public Object getAttribute(String key) {
            return this.attributes != null ? this.attributes.get(key) : null;
        }

        public Map<String, Object> getAttributes() {
            return Collections.unmodifiableMap(this.attributes);
        }
    }

    static class AttachmentSupporter
    implements XAttachmentSupport {
        private Map<Class<?>, Object> attachments;

        AttachmentSupporter() {
        }

        public <T> T addAttachment(Class<T> clazz, T value) {
            if (this.attachments == null) {
                this.attachments = new HashMap();
            }
            Object result = this.attachments.get(clazz);
            this.attachments.put(clazz, value);
            return (T)result;
        }

        public <T> T getAttachment(Class<T> clazz) {
            if (this.attachments == null) {
                return null;
            }
            Object result = this.attachments.get(clazz);
            return (T)result;
        }

        public <T> T removeAttachment(Class<T> clazz) {
            if (this.attachments == null) {
                return null;
            }
            Object result = this.attachments.remove(clazz);
            return (T)result;
        }
    }
}

