/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.jboss;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.catalina.Engine;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardServer;
import org.gatein.wci.jboss.JB7ServletContainerContext;

public class CatalinaIntegration {
    private StandardServer server;
    protected final AtomicBoolean start = new AtomicBoolean(false);
    private LinkedHashMap<Engine, JB7ServletContainerContext> containerContexts = new LinkedHashMap();

    public CatalinaIntegration(StandardServer server) {
        this.server = server;
    }

    public void start() {
        if (this.start.compareAndSet(false, true)) {
            this.start((Server)this.server);
        }
    }

    private void start(Server server) {
        List<Service> services = Arrays.asList(server.findServices());
        for (Service service : services) {
            Engine engine = (Engine)service.getContainer();
            JB7ServletContainerContext containerContext = new JB7ServletContainerContext(engine);
            containerContext.setCrossContextLogout(true);
            containerContext.start();
            this.containerContexts.put(engine, containerContext);
        }
    }

    public void stop() {
        if (this.start.compareAndSet(true, false)) {
            this.stop((Server)this.server);
        }
    }

    private void stop(Server server) {
        List<Service> services = Arrays.asList(server.findServices());
        for (Service service : services) {
            Engine engine = (Engine)service.getContainer();
            JB7ServletContainerContext containerContext = this.containerContexts.get(engine);
            containerContext.stop();
            this.containerContexts.remove(engine);
        }
    }
}

