/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.jboss;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.command.CommandServlet;
import org.gatein.wci.spi.WebAppContext;

public class JB7WebAppContext
implements WebAppContext {
    private static final Logger log = LoggerFactory.getLogger(JB7WebAppContext.class);
    private static final String GATEIN_SERVLET_NAME = "TomcatGateInServlet";
    private ServletContext servletContext;
    private ClassLoader loader;
    private String contextPath;
    private final Context context;
    private Wrapper commandServlet;

    JB7WebAppContext(Context context) throws Exception {
        this.context = context;
        this.servletContext = context.getServletContext();
        this.loader = context.getLoader().getClassLoader();
        this.contextPath = context.getPath();
    }

    public void start() throws Exception {
        Container child = this.context.findChild(GATEIN_SERVLET_NAME);
        if (child == null) {
            try {
                String className = CommandServlet.class.getName();
                try {
                    this.loader.loadClass(className);
                }
                catch (Exception ex) {
                    log.debug((Object)("WCI integration skipped for context: " + this.context));
                    return;
                }
                this.commandServlet = this.context.createWrapper();
                this.commandServlet.setName(GATEIN_SERVLET_NAME);
                this.commandServlet.setLoadOnStartup(0);
                this.commandServlet.setServletClass(className);
                this.context.addChild((Container)this.commandServlet);
                this.context.addServletMapping("/tomcatgateinservlet", GATEIN_SERVLET_NAME);
            }
            catch (Exception e) {
                this.cleanup();
                throw e;
            }
        }
    }

    public void stop() {
        this.cleanup();
    }

    private void cleanup() {
        if (this.commandServlet != null) {
            try {
                this.context.removeServletMapping("/tomcatgateinservlet");
                this.context.removeChild((Container)this.commandServlet);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public boolean importFile(String parentDirRelativePath, String name, InputStream source, boolean overwrite) throws IOException {
        return false;
    }

    public boolean invalidateSession(String sessId) {
        Manager mgr = this.context.getManager();
        if (mgr != null) {
            try {
                Session sess = mgr.findSession(sessId);
                if (sess != null) {
                    sess.expire();
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }
}

