/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.deployment.SecurityActions;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.DeploymentAspectManager;
import org.jboss.wsf.spi.deployment.DeploymentState;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;

public class DeploymentAspectManagerImpl
implements DeploymentAspectManager {
    private static final Logger log = Logger.getLogger(DeploymentAspectManagerImpl.class);
    private String name;
    private DeploymentAspectManager parent;
    private List<DeploymentAspect> depAspects = new ArrayList<DeploymentAspect>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeploymentAspectManager getParent() {
        return this.parent;
    }

    public void setParent(DeploymentAspectManager parent) {
        this.parent = parent;
    }

    public List<DeploymentAspect> getDeploymentAspects() {
        return Collections.unmodifiableList(this.depAspects);
    }

    public void setDeploymentAspects(List<DeploymentAspect> aspects) {
        this.depAspects.clear();
        this.depAspects.addAll(aspects);
        if (log.isTraceEnabled()) {
            StringBuilder builder = new StringBuilder("setDeploymentAspects on " + this.name);
            for (DeploymentAspect aspect : aspects) {
                builder.append("\n  " + aspect.getClass().getName() + " provides: " + aspect.getProvidesAsSet() + " requires: " + aspect.getRequiresAsSet());
            }
            log.trace((Object)builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(Deployment dep) {
        DeploymentAspect aspect;
        int i;
        HashSet providedConditions = new HashSet();
        List<DeploymentAspect> deploymentAspects = this.getDeploymentAspects();
        for (i = 0; i < deploymentAspects.size(); ++i) {
            aspect = deploymentAspects.get(i);
            providedConditions.addAll(aspect.getProvidesAsSet());
        }
        for (i = 0; i < deploymentAspects.size(); ++i) {
            aspect = deploymentAspects.get(i);
            try {
                if (!aspect.canHandle(dep)) continue;
                this.logInvocation(aspect, "Start");
                ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
                try {
                    SecurityActions.setContextClassLoader(aspect.getLoader());
                    aspect.start(dep);
                    continue;
                }
                finally {
                    SecurityActions.setContextClassLoader(origClassLoader);
                }
            }
            catch (RuntimeException rte) {
                while (--i >= 0) {
                    try {
                        this.failsafeStop(deploymentAspects.get(i), dep);
                    }
                    catch (RuntimeException destroyRte) {
                        log.error((Object)BundleUtils.getMessage((ResourceBundle)BundleUtils.getBundle(DeploymentAspectManagerImpl.class), (String)"ERROR_DESTROYING_DEPLOYMENT", (Object[])new Object[0]), (Throwable)rte);
                        throw destroyRte;
                    }
                }
                throw rte;
            }
        }
        dep.setState(DeploymentState.STARTED);
    }

    public void undeploy(Deployment dep) {
        List<DeploymentAspect> deploymentAspects = this.getDeploymentAspects();
        for (int i = deploymentAspects.size(); 0 < i; --i) {
            DeploymentAspect aspect = deploymentAspects.get(i - 1);
            this.failsafeStop(aspect, dep);
        }
        dep.setState(DeploymentState.STOPPED);
    }

    private void failsafeStop(DeploymentAspect aspect, Deployment dep) {
        try {
            this.logInvocation(aspect, "Stop");
            aspect.stop(dep);
        }
        catch (RuntimeException rte) {
            WSFDeploymentException.rethrow((Throwable)rte);
        }
    }

    private void logInvocation(DeploymentAspect aspect, String method) {
        if (log.isTraceEnabled()) {
            String name = aspect.getClass().getName();
            name = name.substring(name.lastIndexOf(".") + 1);
            log.trace((Object)("[" + this.name + "]" + name + ":" + method));
        }
    }
}

