/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.jboss.com.sun.net.httpserver.Headers;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpsServer;
import org.jboss.dmr.ModelNode;

class DomainUtil {
    private DomainUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeResponse(HttpExchange http, boolean isGet, boolean pretty, ModelNode response, int status, boolean encode, String contentType) throws IOException {
        Headers responseHeaders = http.getResponseHeaders();
        responseHeaders.add("Content-Type", contentType);
        http.sendResponseHeaders(status, 0L);
        if (isGet && status == 200) {
            response = response.get("result");
        }
        OutputStream out = http.getResponseBody();
        PrintWriter print = new PrintWriter(out);
        try {
            if (encode) {
                response.writeBase64(out);
            } else {
                response.writeJSONString(print, !pretty);
            }
        }
        finally {
            print.flush();
            out.flush();
            DomainUtil.safeClose(print);
            DomainUtil.safeClose(out);
        }
    }

    static void writeResponse(HttpExchange http, boolean isGet, boolean pretty, ModelNode response, int status, boolean encode) throws IOException {
        String contentType = encode ? "application/dmr-encoded" : "application/json";
        DomainUtil.writeResponse(http, isGet, pretty, response, status, encode, contentType);
    }

    static void safeClose(Closeable close) {
        try {
            close.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static String constructUrl(HttpExchange exchange, String path) {
        Headers headers = exchange.getRequestHeaders();
        String host = headers.getFirst("Host");
        String protocol = exchange.getHttpContext().getServer() instanceof HttpsServer ? "https" : "http";
        return protocol + "://" + host + path;
    }
}

