/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.domain.http.server.HttpServerMessages;
import org.jboss.as.domain.http.server.ManagementHttpHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.com.sun.net.httpserver.Headers;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpHandler;
import org.jboss.com.sun.net.httpserver.HttpServer;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

class ResourceHandler
implements ManagementHttpHandler {
    private static final String EXPIRES_HEADER = "Expires";
    private static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private static final String GMT = "GMT";
    private static final String CACHE_CONTROL_HEADER = "Cache-Control";
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private static Map<String, String> contentTypeMapping = new ConcurrentHashMap<String, String>();
    private static final String FORMAT_STRING = "EEE, dd MMM yyyy HH:mm:ss z";
    private final String context;
    private final String defaultResource;
    private final ClassLoader loader;
    private final String lastModified;
    private long lastExpiryDate = 0L;
    private String lastExpiryHeader = null;
    private final Map<String, ResourceHandle> buffer = new ConcurrentHashMap<String, ResourceHandle>();

    public ResourceHandler(String context, String defaultResource, ClassLoader loader) {
        this.context = context;
        this.defaultResource = defaultResource;
        this.loader = loader;
        this.lastModified = ResourceHandler.createDateFormat().format(new Date());
    }

    String getDefaultPath() {
        return this.context + this.defaultResource;
    }

    protected String getContext() {
        return this.context;
    }

    public void handle(HttpExchange http) throws IOException {
        URI uri = http.getRequestURI();
        String requestMethod = http.getRequestMethod();
        if (!"GET".equals(requestMethod)) {
            http.sendResponseHeaders(405, -1L);
            return;
        }
        String path = uri.getPath();
        String resource = path.substring(this.context.length(), path.length());
        if (resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        if (resource.equals("")) {
            Headers responseHeaders = http.getResponseHeaders();
            responseHeaders.add("Location", this.getDefaultPath());
            http.sendResponseHeaders(301, 0L);
            http.close();
            return;
        }
        if (!resource.contains(".")) {
            this.respond404(http);
        }
        if (resource.startsWith("META-INF")) {
            http.sendResponseHeaders(403, 0L);
            http.close();
            return;
        }
        ResourceHandle handle = this.getResourceHandle(resource);
        if (handle.getInputStream() != null) {
            InputStream inputStream = handle.getInputStream();
            Headers responseHeaders = http.getResponseHeaders();
            responseHeaders.add("Content-Type", this.resolveContentType(path));
            if (!this.skipCache(resource)) {
                if (System.currentTimeMillis() > this.lastExpiryDate) {
                    this.lastExpiryDate = ResourceHandler.calculateExpiryDate();
                    this.lastExpiryHeader = ResourceHandler.createDateFormat().format(new Date(this.lastExpiryDate));
                }
                responseHeaders.add(CACHE_CONTROL_HEADER, "private, max-age=2678400, must-revalidate");
                responseHeaders.add(EXPIRES_HEADER, this.lastExpiryHeader);
            }
            responseHeaders.add(LAST_MODIFIED_HEADER, this.lastModified);
            responseHeaders.add(CONTENT_LENGTH_HEADER, String.valueOf(handle.getSize()));
            http.sendResponseHeaders(200, 0L);
            OutputStream outputStream = http.getResponseBody();
            ResourceHandler.fastChannelCopy(inputStream, outputStream);
            outputStream.flush();
            ResourceHandler.safeClose(outputStream);
            ResourceHandler.safeClose(inputStream);
        } else {
            this.respond404(http);
        }
    }

    private ResourceHandle getResourceHandle(String resource) {
        ResourceHandle handle = this.buffer.get(resource);
        if (handle == null) {
            InputStream resourceStream = this.getLoader().getResourceAsStream(resource);
            if (resourceStream != null) {
                try {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    ResourceHandler.fastChannelCopy(resourceStream, bout);
                    bout.flush();
                    bout.close();
                    resourceStream.close();
                    handle = new ResourceHandle(bout.toByteArray());
                }
                catch (IOException e) {
                    throw HttpServerMessages.MESSAGES.failedReadingResource(e, resource);
                }
                this.buffer.put(resource, handle);
            } else {
                handle = new ResourceHandle(null);
            }
        }
        return handle;
    }

    private static DateFormat createDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_STRING, Locale.US);
        df.setTimeZone(TimeZone.getTimeZone(GMT));
        return df;
    }

    private static long calculateExpiryDate() {
        Calendar cal = Calendar.getInstance();
        cal.roll(2, 1);
        return cal.getTime().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fastChannelCopy(InputStream in, OutputStream out) throws IOException {
        ReadableByteChannel src = Channels.newChannel(in);
        WritableByteChannel dest = Channels.newChannel(out);
        try {
            ByteBuffer buffer = ByteBuffer.allocate(8192);
            while (src.read(buffer) != -1) {
                buffer.flip();
                dest.write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                dest.write(buffer);
            }
        }
        finally {
            ResourceHandler.safeClose(src);
            ResourceHandler.safeClose(dest);
        }
    }

    private static void safeClose(Closeable close) {
        try {
            if (close != null) {
                close.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String resolveContentType(String resource) {
        assert (resource.indexOf(".") != -1) : HttpServerMessages.MESSAGES.invalidResource();
        String contentType = null;
        for (String suffix : contentTypeMapping.keySet()) {
            if (!resource.endsWith(suffix)) continue;
            contentType = contentTypeMapping.get(suffix);
            break;
        }
        if (null == contentType) {
            contentType = "application/octet-stream";
        }
        return contentType;
    }

    private void respond404(HttpExchange http) throws IOException {
        Headers responseHeaders = http.getResponseHeaders();
        responseHeaders.add("Content-Type", "text/html");
        http.sendResponseHeaders(404, 0L);
        OutputStream out = http.getResponseBody();
        out.flush();
        ResourceHandler.safeClose(out);
    }

    private ClassLoader getLoader() {
        return this.loader;
    }

    @Override
    public void start(HttpServer httpServer, SecurityRealm securityRealm) {
        httpServer.createContext(this.context, (HttpHandler)this);
    }

    @Override
    public void stop(HttpServer httpServer) {
        httpServer.removeContext(this.context);
    }

    protected static ClassLoader getClassLoader(String module, String slot) throws ModuleLoadException {
        ModuleIdentifier id = ModuleIdentifier.create((String)module, (String)slot);
        ModuleClassLoader cl = Module.getCallerModuleLoader().loadModule(id).getClassLoader();
        return cl;
    }

    protected boolean skipCache(String resource) {
        return false;
    }

    static {
        contentTypeMapping.put(".js", "application/javascript");
        contentTypeMapping.put(".html", "text/html");
        contentTypeMapping.put(".htm", "text/html");
        contentTypeMapping.put(".css", "text/css");
        contentTypeMapping.put(".gif", "image/gif");
        contentTypeMapping.put(".png", "image/png");
        contentTypeMapping.put(".jpeg", "image/jpeg");
    }

    class ResourceHandle {
        private final byte[] content;

        ResourceHandle(byte[] content) {
            this.content = content;
        }

        public int getSize() {
            return this.content.length;
        }

        public InputStream getInputStream() {
            return this.content != null ? new ByteArrayInputStream(this.content) : null;
        }
    }
}

