/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBytes;

public class ValueJavaObject
extends ValueBytes {
    private static final ValueJavaObject EMPTY = new ValueJavaObject(Utils.EMPTY_BYTES);

    protected ValueJavaObject(byte[] byArray) {
        super(byArray);
    }

    public static ValueJavaObject getNoCopy(Object object, byte[] byArray) {
        ValueJavaObject valueJavaObject;
        if (byArray != null && byArray.length == 0) {
            return EMPTY;
        }
        if (SysProperties.SERIALIZE_JAVA_OBJECT) {
            if (byArray == null) {
                byArray = Utils.serialize(object);
            }
            valueJavaObject = new ValueJavaObject(byArray);
        } else {
            valueJavaObject = new NotSerialized(object, byArray);
        }
        if (byArray == null || byArray.length > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return valueJavaObject;
        }
        return (ValueJavaObject)Value.cache(valueJavaObject);
    }

    @Override
    public int getType() {
        return 19;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        Object object = Utils.deserialize(this.getBytesNoCopy());
        preparedStatement.setObject(n, object, 2000);
    }

    private static class NotSerialized
    extends ValueJavaObject {
        private Object javaObject;
        private int displaySize = -1;

        NotSerialized(Object object, byte[] byArray) {
            super(byArray);
            this.javaObject = object;
        }

        @Override
        public void set(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setObject(n, this.getObject(), 2000);
        }

        @Override
        public byte[] getBytesNoCopy() {
            if (this.value == null) {
                this.value = Utils.serialize(this.javaObject);
            }
            return this.value;
        }

        @Override
        protected int compareSecure(Value value, CompareMode compareMode) {
            int n;
            Object object = this.getObject();
            Object object2 = value.getObject();
            boolean bl = object instanceof Comparable;
            boolean bl2 = object2 instanceof Comparable;
            if (bl && bl2 && Utils.haveCommonComparableSuperclass(object.getClass(), object2.getClass())) {
                Comparable comparable = (Comparable)object;
                return comparable.compareTo(object2);
            }
            if (object.getClass() != object2.getClass()) {
                if (bl != bl2) {
                    return bl ? -1 : 1;
                }
                return object.getClass().getName().compareTo(object2.getClass().getName());
            }
            int n2 = this.hashCode();
            if (n2 == (n = value.hashCode())) {
                if (object.equals(object2)) {
                    return 0;
                }
                return Utils.compareNotNull(this.getBytesNoCopy(), value.getBytesNoCopy());
            }
            return n2 > n ? 1 : -1;
        }

        @Override
        public String getString() {
            String string = this.getObject().toString();
            if (this.displaySize == -1) {
                this.displaySize = string.length();
            }
            return string;
        }

        @Override
        public long getPrecision() {
            return 0L;
        }

        @Override
        public int hashCode() {
            if (this.hash == 0) {
                this.hash = this.getObject().hashCode();
            }
            return this.hash;
        }

        @Override
        public Object getObject() {
            if (this.javaObject == null) {
                this.javaObject = Utils.deserialize(this.value);
            }
            return this.javaObject;
        }

        @Override
        public int getDisplaySize() {
            if (this.displaySize == -1) {
                this.displaySize = this.getString().length();
            }
            return this.displaySize;
        }

        @Override
        public int getMemory() {
            if (this.value == null) {
                return DataType.getDataType((int)this.getType()).memory;
            }
            int n = super.getMemory();
            if (this.javaObject != null) {
                n *= 2;
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof NotSerialized)) {
                return false;
            }
            return this.getObject().equals(((NotSerialized)object).getObject());
        }

        @Override
        public Value convertPrecision(long l, boolean bl) {
            return this;
        }
    }
}

