/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.enterprise.event.Event;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.bean.builtin.AbstractFacade;
import org.jboss.weld.bean.builtin.FacadeInjectionPoint;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.logging.messages.EventMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.reflection.Formats;

public class EventImpl<T>
extends AbstractFacade<T, Event<T>>
implements Event<T>,
Serializable {
    private static final long serialVersionUID = 656782657242515455L;

    public static <E> EventImpl<E> of(InjectionPoint injectionPoint, BeanManagerImpl beanManager) {
        return new EventImpl(injectionPoint, beanManager);
    }

    private EventImpl(InjectionPoint injectionPoint, BeanManagerImpl beanManager) {
        super(injectionPoint, null, beanManager);
    }

    public String toString() {
        return Formats.formatAnnotations(this.getQualifiers()) + " Event<" + Formats.formatType(this.getType()) + ">";
    }

    public void fire(T event) {
        this.getBeanManager().getAccessibleObserverNotifier().fireEvent(this.getType(), event, this.getQualifiers());
    }

    public Event<T> select(Annotation ... qualifiers) {
        return this.selectEvent(this.getType(), qualifiers);
    }

    public <U extends T> Event<U> select(Class<U> subtype, Annotation ... qualifiers) {
        return this.selectEvent(subtype, qualifiers);
    }

    public <U extends T> Event<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return this.selectEvent(subtype.getType(), qualifiers);
    }

    private <U extends T> Event<U> selectEvent(Type subtype, Annotation[] newQualifiers) {
        Observers.checkEventObjectType(this.getBeanManager(), subtype);
        return new EventImpl<T>(new FacadeInjectionPoint(this.getInjectionPoint(), subtype, this.getQualifiers(), newQualifiers), this.getBeanManager());
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException(EventMessage.PROXY_REQUIRED, new Object[0]);
    }

    private static class SerializationProxy<T>
    extends AbstractFacade.AbstractFacadeSerializationProxy<T, Event<T>> {
        private static final long serialVersionUID = 9181171328831559650L;

        public SerializationProxy(EventImpl<T> event) {
            super(event);
        }

        private Object readResolve() {
            return EventImpl.of(this.getInjectionPoint(), this.getBeanManager());
        }
    }
}

