/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.plugins.saml;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.interfaces.SecurityTokenProvider;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.factories.SAMLAssertionFactory;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.util.StatementUtil;
import org.picketlink.identity.federation.core.sts.AbstractSecurityTokenProvider;
import org.picketlink.identity.federation.core.wstrust.StandardSecurityToken;
import org.picketlink.identity.federation.core.wstrust.WSTrustRequestContext;
import org.picketlink.identity.federation.core.wstrust.WSTrustUtil;
import org.picketlink.identity.federation.core.wstrust.plugins.saml.SAML20TokenAttributeProvider;
import org.picketlink.identity.federation.core.wstrust.plugins.saml.SAMLUtil;
import org.picketlink.identity.federation.core.wstrust.plugins.saml.SecurityActions;
import org.picketlink.identity.federation.core.wstrust.wrappers.Lifetime;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AudienceRestrictionType;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionsType;
import org.picketlink.identity.federation.saml.v2.assertion.KeyInfoConfirmationDataType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.federation.ws.policy.AppliesTo;
import org.picketlink.identity.federation.ws.trust.RequestedReferenceType;
import org.picketlink.identity.federation.ws.trust.StatusType;
import org.picketlink.identity.federation.ws.wss.secext.KeyIdentifierType;
import org.w3c.dom.Element;

public class SAML20TokenProvider
extends AbstractSecurityTokenProvider
implements SecurityTokenProvider {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private SAML20TokenAttributeProvider attributeProvider;

    @Override
    public void initialize(Map<String, String> properties) {
        super.initialize(properties);
        String attributeProviderClassName = (String)this.properties.get("AttributeProvider");
        if (attributeProviderClassName == null) {
            logger.trace("No attribute provider set");
        } else {
            try {
                Class<?> clazz = SecurityActions.loadClass(this.getClass(), attributeProviderClassName);
                Object object = clazz.newInstance();
                if (object instanceof SAML20TokenAttributeProvider) {
                    this.attributeProvider = (SAML20TokenAttributeProvider)object;
                    this.attributeProvider.setProperties(this.properties);
                } else {
                    logger.stsWrongAttributeProviderTypeNotInstalled(attributeProviderClassName);
                }
            }
            catch (Exception pae) {
                logger.attributeProviderInstationError(pae);
            }
        }
    }

    @Override
    public void cancelToken(ProtocolContext protoContext) throws ProcessingException {
        if (!(protoContext instanceof WSTrustRequestContext)) {
            return;
        }
        WSTrustRequestContext context = (WSTrustRequestContext)protoContext;
        Element token = context.getRequestSecurityToken().getCancelTargetElement();
        if (token == null) {
            throw logger.wsTrustNullCancelTargetError();
        }
        Element assertionElement = (Element)token.getFirstChild();
        if (!this.isAssertion(assertionElement)) {
            throw logger.assertionInvalidError();
        }
        String assertionId = assertionElement.getAttribute("ID");
        this.revocationRegistry.revokeToken("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0", assertionId);
    }

    @Override
    public void issueToken(ProtocolContext protoContext) throws ProcessingException {
        AttributeStatementType attributeStatement;
        if (!(protoContext instanceof WSTrustRequestContext)) {
            return;
        }
        WSTrustRequestContext context = (WSTrustRequestContext)protoContext;
        String assertionID = IDGenerator.create("ID_");
        Lifetime lifetime = context.getRequestSecurityToken().getLifetime();
        AudienceRestrictionType restriction = null;
        AppliesTo appliesTo = context.getRequestSecurityToken().getAppliesTo();
        if (appliesTo != null) {
            restriction = SAMLAssertionFactory.createAudienceRestriction(WSTrustUtil.parseAppliesTo(appliesTo));
        }
        ConditionsType conditions = SAMLAssertionFactory.createConditions(lifetime.getCreated(), lifetime.getExpires(), restriction);
        Principal principal = context.getCallerPrincipal();
        String confirmationMethod = null;
        KeyInfoConfirmationDataType keyInfoDataType = null;
        if (context.getOnBehalfOfPrincipal() != null) {
            principal = context.getOnBehalfOfPrincipal();
            confirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches";
        } else if (context.getProofTokenInfo() != null) {
            confirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
            keyInfoDataType = SAMLAssertionFactory.createKeyInfoConfirmation(context.getProofTokenInfo());
        } else {
            confirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
        }
        SubjectConfirmationType subjectConfirmation = SAMLAssertionFactory.createSubjectConfirmation(null, confirmationMethod, keyInfoDataType);
        String subjectName = principal == null ? "ANONYMOUS" : principal.getName();
        NameIDType nameID = SAMLAssertionFactory.createNameID(null, "urn:picketlink:identity-federation", subjectName);
        SubjectType subject = SAMLAssertionFactory.createSubject(nameID, subjectConfirmation);
        ArrayList<StatementAbstractType> statements = null;
        Map<String, Object> claimedAttributes = context.getClaimedAttributes();
        if (claimedAttributes != null) {
            statements = new ArrayList<StatementAbstractType>();
            statements.add(StatementUtil.createAttributeStatement(claimedAttributes));
        }
        NameIDType issuerID = SAMLAssertionFactory.createNameID(null, null, context.getTokenIssuer());
        AssertionType assertion = SAMLAssertionFactory.createAssertion(assertionID, issuerID, lifetime.getCreated(), conditions, subject, statements);
        if (this.attributeProvider != null && (attributeStatement = this.attributeProvider.getAttributeStatement()) != null) {
            assertion.addStatement(attributeStatement);
        }
        Element assertionElement = null;
        try {
            assertionElement = SAMLUtil.toElement(assertion);
        }
        catch (Exception e) {
            throw logger.samlAssertionMarshallError(e);
        }
        StandardSecurityToken token = new StandardSecurityToken(context.getRequestSecurityToken().getTokenType().toString(), assertionElement, assertionID);
        context.setSecurityToken(token);
        KeyIdentifierType keyIdentifier = WSTrustUtil.createKeyIdentifier("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID", "#" + assertionID);
        HashMap<QName, String> attributes = new HashMap<QName, String>();
        attributes.put(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType", "wsse11"), "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        RequestedReferenceType attachedReference = WSTrustUtil.createRequestedReference(keyIdentifier, attributes);
        context.setAttachedReference(attachedReference);
    }

    @Override
    public void renewToken(ProtocolContext protoContext) throws ProcessingException {
        if (!(protoContext instanceof WSTrustRequestContext)) {
            return;
        }
        WSTrustRequestContext context = (WSTrustRequestContext)protoContext;
        Element token = context.getRequestSecurityToken().getRenewTargetElement();
        if (token == null) {
            throw logger.wsTrustNullRenewTargetError();
        }
        Element oldAssertionElement = (Element)token.getFirstChild();
        if (!this.isAssertion(oldAssertionElement)) {
            throw logger.assertionInvalidError();
        }
        AssertionType oldAssertion = null;
        try {
            oldAssertion = SAMLUtil.fromElement(oldAssertionElement);
        }
        catch (Exception je) {
            throw logger.samlAssertionUnmarshallError(je);
        }
        if (this.revocationRegistry.isRevoked("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0", oldAssertion.getID())) {
            throw logger.samlAssertionRevokedCouldNotRenew(oldAssertion.getID());
        }
        ConditionsType conditions = oldAssertion.getConditions();
        conditions.setNotBefore(context.getRequestSecurityToken().getLifetime().getCreated());
        conditions.setNotOnOrAfter(context.getRequestSecurityToken().getLifetime().getExpires());
        String assertionID = IDGenerator.create("ID_");
        ArrayList<StatementAbstractType> statements = new ArrayList<StatementAbstractType>();
        statements.addAll(oldAssertion.getStatements());
        AssertionType newAssertion = SAMLAssertionFactory.createAssertion(assertionID, oldAssertion.getIssuer(), context.getRequestSecurityToken().getLifetime().getCreated(), conditions, oldAssertion.getSubject(), statements);
        Element assertionElement = null;
        try {
            assertionElement = SAMLUtil.toElement(newAssertion);
        }
        catch (Exception e) {
            throw logger.samlAssertionMarshallError(e);
        }
        StandardSecurityToken securityToken = new StandardSecurityToken(context.getRequestSecurityToken().getTokenType().toString(), assertionElement, assertionID);
        context.setSecurityToken(securityToken);
        KeyIdentifierType keyIdentifier = WSTrustUtil.createKeyIdentifier("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID", "#" + assertionID);
        HashMap<QName, String> attributes = new HashMap<QName, String>();
        attributes.put(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType"), "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        RequestedReferenceType attachedReference = WSTrustUtil.createRequestedReference(keyIdentifier, attributes);
        context.setAttachedReference(attachedReference);
    }

    @Override
    public void validateToken(ProtocolContext protoContext) throws ProcessingException {
        if (!(protoContext instanceof WSTrustRequestContext)) {
            return;
        }
        WSTrustRequestContext context = (WSTrustRequestContext)protoContext;
        logger.trace("SAML token validation started");
        Element token = context.getRequestSecurityToken().getValidateTargetElement();
        if (token == null) {
            throw logger.wsTrustNullValidationTargetError();
        }
        String code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/valid";
        String reason = "SAMLV2.0 Assertion successfuly validated";
        AssertionType assertion = null;
        Element assertionElement = (Element)token.getFirstChild();
        if (!this.isAssertion(assertionElement)) {
            code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
            reason = "Validation failure: supplied token is not a SAMLV2.0 Assertion";
        } else {
            try {
                if (logger.isTraceEnabled()) {
                    logger.samlAssertion(DocumentUtil.getNodeAsString(assertionElement));
                }
                assertion = SAMLUtil.fromElement(assertionElement);
            }
            catch (Exception e) {
                throw logger.samlAssertionUnmarshallError(e);
            }
        }
        if (this.revocationRegistry.isRevoked("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0", assertion.getID())) {
            code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
            reason = "Validation failure: assertion with id " + assertion.getID() + " has been canceled";
        }
        try {
            if (AssertionUtil.hasExpired(assertion)) {
                code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
                reason = "Validation failure: assertion expired or used before its lifetime period";
            }
        }
        catch (Exception ce) {
            code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
            reason = "Validation failure: unable to verify assertion lifetime: " + ce.getMessage();
        }
        StatusType status = new StatusType();
        status.setCode(code);
        status.setReason(reason);
        context.setStatus(status);
    }

    private boolean isAssertion(Element element) {
        return element == null ? false : "Assertion".equals(element.getLocalName()) && "urn:oasis:names:tc:SAML:2.0:assertion".equals(element.getNamespaceURI());
    }

    @Override
    public boolean supports(String namespace) {
        return "http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(namespace);
    }

    @Override
    public String tokenType() {
        return "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0";
    }

    @Override
    public QName getSupportedQName() {
        return new QName(this.tokenType(), JBossSAMLConstants.ASSERTION.get());
    }

    @Override
    public String family() {
        return SecurityTokenProvider.FAMILY_TYPE.WS_TRUST.toString();
    }
}

