/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.config;

import java.io.InputStream;
import org.picketlink.identity.federation.core.config.IDPType;
import org.picketlink.identity.federation.core.config.SPType;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.saml.v2.metadata.EntitiesDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.picketlink.identity.federation.web.config.AbstractSAMLConfigurationProvider;
import org.picketlink.identity.federation.web.config.SecurityActions;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;

public class IDPMetadataConfigurationProvider
extends AbstractSAMLConfigurationProvider
implements SAMLConfigurationProvider {
    public static final String IDP_MD_FILE = "idp-metadata.xml";

    @Override
    public IDPType getIDPConfiguration() throws ProcessingException {
        IDPType idpType = null;
        if (this.fileAvailable()) {
            try {
                EntitiesDescriptorType entities = this.parseMDFile();
                IDPSSODescriptorType idpSSO = CoreConfigUtil.getIDPDescriptor(entities);
                if (idpSSO != null) {
                    idpType = CoreConfigUtil.getIDPType(idpSSO);
                }
            }
            catch (ParsingException e) {
                throw logger.processingError(e);
            }
        }
        if (this.configParsedIDPType != null) {
            idpType.importFrom(this.configParsedIDPType);
        }
        return idpType;
    }

    @Override
    public SPType getSPConfiguration() throws ProcessingException {
        throw new RuntimeException("PL00020: Illegal Method Called");
    }

    private boolean fileAvailable() {
        InputStream is = SecurityActions.loadStream(this.getClass(), IDP_MD_FILE);
        return is != null;
    }

    private EntitiesDescriptorType parseMDFile() throws ParsingException {
        InputStream is = SecurityActions.loadStream(this.getClass(), IDP_MD_FILE);
        if (is == null) {
            throw logger.nullValueError(IDP_MD_FILE);
        }
        SAMLParser parser = new SAMLParser();
        return (EntitiesDescriptorType)parser.parse(is);
    }
}

