/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.test.authentication;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import junit.framework.Assert;
import org.gatein.wci.authentication.AuthenticationEvent;
import org.gatein.wci.authentication.AuthenticationEventType;
import org.gatein.wci.test.AbstractWCITestCase;
import org.gatein.wci.test.authentication.AuthenticationServlet;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Test;

public abstract class AbstractAuthenticationTestCase
extends AbstractWCITestCase {
    private static URL url;

    private static URL readURL(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[256];
        int i = in.read(buffer);
        while (i != -1) {
            baos.write(buffer, 0, i);
            i = in.read(buffer);
        }
        return new URL(baos.toString());
    }

    @Test
    @RunAsClient
    @InSequence(value=0)
    public void testFoo(@ArquillianResource URL deploymentURL) throws Exception {
        AuthenticationServlet.status = 0;
        HttpURLConnection conn = (HttpURLConnection)deploymentURL.openConnection();
        conn.connect();
        Assert.assertEquals((int)200, (int)conn.getResponseCode());
    }

    @Test
    @InSequence(value=1)
    public void testUserIsNotAuthenticated() {
        Assert.assertNull((Object)AuthenticationServlet.remoteUser);
        Assert.assertEquals(Collections.emptyList(), AuthenticationServlet.authEvents);
        AuthenticationServlet.status = 1;
    }

    @Test
    @RunAsClient
    @InSequence(value=2)
    public void testFoo2(@ArquillianResource URL deploymentURL) throws Exception {
        HttpURLConnection conn = (HttpURLConnection)deploymentURL.openConnection();
        conn.connect();
        Assert.assertEquals((int)401, (int)conn.getResponseCode());
    }

    @Test
    @InSequence(value=3)
    public void testAuthenticationFailure() {
        Assert.assertNull((Object)AuthenticationServlet.remoteUser);
        Assert.assertEquals((int)1, (int)AuthenticationServlet.authEvents.size());
        AuthenticationEvent event = AuthenticationServlet.authEvents.removeFirst();
        Assert.assertEquals((Object)AuthenticationEventType.FAILED, (Object)event.getType());
        AuthenticationServlet.status = 2;
    }

    @Test
    @RunAsClient
    @InSequence(value=4)
    public void testFoo3(@ArquillianResource URL deploymentURL) throws Exception {
        HttpURLConnection conn = (HttpURLConnection)deploymentURL.openConnection();
        conn.connect();
        Assert.assertEquals((int)200, (int)conn.getResponseCode());
        url = AbstractAuthenticationTestCase.readURL(conn.getInputStream());
    }

    @Test
    @InSequence(value=5)
    public void testUserIsAuthenticated() {
        Assert.assertEquals((String)"foo", (String)AuthenticationServlet.remoteUser);
        Assert.assertEquals((int)1, (int)AuthenticationServlet.authEvents.size());
        AuthenticationEvent event = AuthenticationServlet.authEvents.removeFirst();
        Assert.assertEquals((Object)AuthenticationEventType.LOGIN, (Object)event.getType());
        Assert.assertEquals((String)"foo", (String)event.getCredentials().getUsername());
        Assert.assertEquals((String)"bar", (String)event.getCredentials().getPassword());
        AuthenticationServlet.status = 3;
    }

    @Test
    @RunAsClient
    @InSequence(value=6)
    public void testFoo4() throws Exception {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        Assert.assertEquals((int)200, (int)conn.getResponseCode());
        url = AbstractAuthenticationTestCase.readURL(conn.getInputStream());
    }

    @Test
    @InSequence(value=7)
    public void testUserRemainsAuthenticated() {
        Assert.assertEquals((String)"foo", (String)AuthenticationServlet.remoteUser);
        Assert.assertEquals(Collections.emptyList(), AuthenticationServlet.authEvents);
        AuthenticationServlet.status = 4;
    }

    @Test
    @RunAsClient
    @InSequence(value=8)
    public void testFoo5() throws Exception {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        Assert.assertEquals((int)200, (int)conn.getResponseCode());
    }

    @Test
    @InSequence(value=9)
    public void testUserIsLoggeOut() {
        Assert.assertNull((Object)AuthenticationServlet.remoteUser);
        Assert.assertEquals((int)0, (int)AuthenticationServlet.authEvents.size());
        AuthenticationServlet.status = 5;
    }
}

