/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.test.requestdispatch;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.wci.RequestDispatchCallback;
import org.gatein.wci.ServletContextDispatcher;
import org.gatein.wci.test.requestdispatch.AbstractCallback;

public class ExceptionCallback
extends AbstractCallback {
    private final ServletContext target;
    private final Throwable expectedThrowable;
    private final Throwable throwable;

    public ExceptionCallback(ServletContext target, Throwable expectedThrowable, Throwable throwable) {
        this.target = target;
        this.expectedThrowable = expectedThrowable;
        this.throwable = throwable;
    }

    @Override
    protected Throwable test(ServletContextDispatcher dispatcher) {
        try {
            dispatcher.include(this.target, (RequestDispatchCallback)this, null);
            return new Exception("Got no throwable thrown was expecting " + this.expectedThrowable);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ServletException) {
                throwable = throwable.getCause();
            }
            if (this.expectedThrowable != throwable) {
                return new Exception("Got throwable " + throwable + " instead of throwable " + this.expectedThrowable);
            }
            return null;
        }
    }

    public Object doCallback(ServletContext dispatchedServletContext, HttpServletRequest dispatchedRequest, HttpServletResponse dispatchedResponse, Object handback) throws ServletException, IOException {
        if (this.throwable instanceof IOException) {
            throw (IOException)this.throwable;
        }
        if (this.throwable instanceof Exception) {
            throw new ServletException(this.throwable);
        }
        if (this.throwable instanceof Error) {
            throw (Error)this.throwable;
        }
        return null;
    }
}

