/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.util.MultiValuedPropertyMap;
import org.gatein.common.xml.XMLTools;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.ResponseProperties;
import org.gatein.pc.controller.state.PageNavigationalState;
import org.gatein.pc.test.controller.AbstractMarkupRenderer;
import org.gatein.pc.test.controller.FragmentRenderer;
import org.gatein.pc.test.controller.RendererContext;
import org.gatein.pc.test.controller.SimpleFragmentRenderer;
import org.w3c.dom.Element;

public class PageRenderer
extends AbstractMarkupRenderer {
    protected FragmentRenderer fragmentRenderer = new SimpleFragmentRenderer();
    protected List<ContentResponse> fragments;
    protected List<ErrorResponse> errors;
    protected PageNavigationalState pageNavigationalState;

    public PageRenderer(ResponseProperties properties, PageNavigationalState pageNavigationalState) {
        super(properties);
        this.pageNavigationalState = pageNavigationalState;
    }

    public void setFragmentRenderer(FragmentRenderer fragmentRenderer) {
        this.fragmentRenderer = fragmentRenderer;
    }

    @Override
    protected void renderContent(HttpServletResponse resp) throws IOException {
        resp.setContentType("text/html");
        PrintWriter writer = resp.getWriter();
        writer.print("<html>");
        writer.print("<head>");
        MultiValuedPropertyMap markupHeaders = this.properties.getMarkupHeaders();
        List headElement = markupHeaders.getValues("javax.portlet.markup.head.element");
        if (headElement != null) {
            for (Element headerValue : headElement) {
                try {
                    String serializedElement = XMLTools.toString((Element)headerValue);
                    writer.print(serializedElement);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        writer.print("</head>");
        writer.print("<body>");
        for (ContentResponse fragment : this.fragments) {
            writer.print(this.fragmentRenderer.renderPortlet(fragment));
        }
        for (ErrorResponse error : this.errors) {
            writer.print(this.fragmentRenderer.renderError(error));
        }
        writer.print("</body></html>");
    }

    @Override
    protected void prepareRendering(RendererContext context) {
        ResponseProperties renderProperties = new ResponseProperties();
        Collection<Portlet> portlets = context.getPortlets();
        int capacity = portlets.size();
        this.fragments = new ArrayList<ContentResponse>(capacity);
        this.errors = new ArrayList<ErrorResponse>(capacity);
        for (Portlet portlet : portlets) {
            try {
                PortletInvocationResponse response = context.render(this.properties.getCookies(), this.pageNavigationalState, portlet.getContext().getId());
                if (response instanceof ContentResponse) {
                    ContentResponse fragment = (ContentResponse)response;
                    this.fragments.add(fragment);
                    ResponseProperties fragmentProperties = fragment.getProperties();
                    if (fragmentProperties == null) continue;
                    renderProperties.append(fragmentProperties);
                    continue;
                }
                if (!(response instanceof ErrorResponse)) continue;
                ErrorResponse error = (ErrorResponse)response;
                this.errors.add(error);
            }
            catch (PortletInvokerException e) {
                e.printStackTrace();
            }
        }
        this.properties.append(renderProperties);
    }
}

