/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.controller.tck;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.invocation.response.ResponseProperties;
import org.gatein.pc.controller.ControllerContext;
import org.gatein.pc.controller.PortletController;
import org.gatein.pc.controller.request.ControllerRequest;
import org.gatein.pc.controller.response.ControllerResponse;
import org.gatein.pc.controller.state.PageNavigationalState;
import org.gatein.pc.test.controller.ControllerResponseRendererFactory;
import org.gatein.pc.test.controller.PageRenderer;
import org.gatein.pc.test.controller.Renderer;
import org.gatein.pc.test.controller.tck.TCKPortletControllerContext;
import org.gatein.pc.test.controller.tck.TCKRendererContext;
import org.gatein.pc.test.controller.unit.ControllerRequestFactory;

public class TCKServlet
extends HttpServlet {
    public static String TCK_PORTLET_NAME = "portletName";

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this._service(req, resp);
        }
        catch (Exception e) {
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ServletException((Throwable)e);
        }
    }

    protected void _service(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        TCKPortletControllerContext context = new TCKPortletControllerContext(req, resp, this.getServletContext());
        PortletController controller = new PortletController();
        String type = req.getParameter("type");
        if ("portlet".equals(type)) {
            ControllerRequestFactory factory = new ControllerRequestFactory(context.getPageNavigationalStateSerialization());
            ControllerRequest request = factory.decode(req);
            PageNavigationalState tckPageNavigationalState = request.getPageNavigationalState();
            ControllerResponse response = controller.process((ControllerContext)context, request);
            ControllerResponseRendererFactory rendererFactory = new ControllerResponseRendererFactory(false, false, request.getPageNavigationalState());
            Renderer renderer = rendererFactory.getRenderer(response);
            renderer.render(new TCKRendererContext(context, tckPageNavigationalState));
        } else {
            String[] tckParamers = req.getParameterValues(TCK_PORTLET_NAME);
            Set<Portlet> portlets = context.getPortlets();
            LinkedHashSet<String> involvedPortlets = new LinkedHashSet<String>();
            for (String tckParamer : tckParamers) {
                String[] parts = tckParamer.split("/");
                String portletAppName = parts[0];
                String portletName = parts[1];
                for (Portlet portlet : portlets) {
                    if (!portlet.getInfo().getApplicationName().equals(portletAppName) || !portlet.getInfo().getName().equals(portletName)) continue;
                    involvedPortlets.add(portlet.getContext().getId());
                }
            }
            if (tckParamers.length > 0 && involvedPortlets.isEmpty()) {
                throw new IllegalStateException("Portlets requested by TCK were not found");
            }
            PageNavigationalState tckPageNavigationalState = new PageNavigationalState(false);
            PageRenderer renderer = new PageRenderer(new ResponseProperties(), tckPageNavigationalState);
            renderer.render(new TCKRendererContext(context, tckPageNavigationalState));
        }
    }
}

