/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.controller.unit;

import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.io.IOTools;
import org.gatein.common.io.Serialization;
import org.gatein.common.io.SerializationFilter;
import org.gatein.common.text.CharBuffer;
import org.gatein.common.text.CharEncoder;
import org.gatein.common.text.FastURLEncoder;
import org.gatein.common.util.Base64;
import org.gatein.pc.api.ContainerURL;
import org.gatein.pc.api.URLFormat;
import org.gatein.pc.controller.state.PageNavigationalState;
import org.gatein.pc.test.controller.unit.ControllerRequestParameterMapFactory;

public class PortletURLRenderer {
    final Serialization<PageNavigationalState> serialization;
    final HttpServletRequest clientReq;
    final HttpServletResponse clientResp;
    final PageNavigationalState pageNS;

    public PortletURLRenderer(PageNavigationalState pageNS, HttpServletRequest clientReq, HttpServletResponse clientResp, Serialization<PageNavigationalState> serialization) {
        this.pageNS = pageNS;
        this.clientReq = clientReq;
        this.clientResp = clientResp;
        this.serialization = serialization;
    }

    private String renderURL(Map<String, String> parameters, URLFormat format) {
        CharBuffer buffer = new CharBuffer();
        buffer.append((CharSequence)this.clientReq.getScheme());
        buffer.append((CharSequence)"://");
        buffer.append((CharSequence)this.clientReq.getServerName());
        buffer.append(':');
        buffer.append((CharSequence)Integer.toString(this.clientReq.getServerPort()));
        buffer.append((CharSequence)this.clientReq.getContextPath());
        buffer.append((CharSequence)this.clientReq.getServletPath());
        if (this.clientReq.getPathInfo() != null) {
            buffer.append((CharSequence)this.clientReq.getPathInfo());
        }
        String parameterSeparator = format.getWantEscapeXML() == Boolean.TRUE ? "&amp;" : "&";
        boolean first = true;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            buffer.append((CharSequence)(first ? "?" : parameterSeparator));
            buffer.append(name, (CharEncoder)FastURLEncoder.getUTF8Instance());
            buffer.append('=');
            buffer.append(value, (CharEncoder)FastURLEncoder.getUTF8Instance());
            first = false;
        }
        String url = buffer.asString();
        return this.clientResp.encodeURL(url);
    }

    public String renderURL(URLFormat format) {
        String pageNavigationalState = null;
        if (this.pageNS != null) {
            byte[] bytes = IOTools.serialize(this.serialization, (SerializationFilter)SerializationFilter.COMPRESSOR, (Object)this.pageNS);
            pageNavigationalState = Base64.encodeBytes((byte[])bytes, (Base64.EncodingOption)Base64.EncodingOption.USEURLSAFEENCODING);
        }
        Map<Object, Object> parameters = pageNavigationalState != null ? Collections.singletonMap("pagenavigationalstate", pageNavigationalState) : Collections.emptyMap();
        return this.renderURL(parameters, format);
    }

    public String renderURL(String windowId, ContainerURL containerURL, URLFormat format) {
        ControllerRequestParameterMapFactory factory = new ControllerRequestParameterMapFactory(this.serialization);
        Map<String, String> parameters = factory.encode(this.pageNS, windowId, containerURL);
        parameters.put("type", "portlet");
        return this.renderURL(parameters, format);
    }
}

