/*
 * Decompiled with CFR 0.152.
 */
package org.wsrp.wss.jboss5.handlers.consumer;

import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.gatein.wci.security.Credentials;
import org.gatein.wsrp.wss.CredentialsAccess;
import org.gatein.wsrp.wss.credentials.CredentialsAccessor;
import org.jboss.ws.core.CommonMessageContext;
import org.wsrp.wss.jboss5.handlers.AbstractWSSecurityCredentialHandler;

public class WSSecurityCredentialHandler
extends AbstractWSSecurityCredentialHandler {
    @Override
    protected boolean handleRequest(SOAPMessageContext soapMessageContext) {
        try {
            log.debug("Attempting to convert security context to WS-Security header");
            CommonMessageContext ctx = (CommonMessageContext)soapMessageContext;
            CredentialsAccessor credentialsAccessor = CredentialsAccess.getInstance().getCredentialsAccessor();
            if (credentialsAccessor != null && credentialsAccessor.getCredentials() != null) {
                Credentials credentials = credentialsAccessor.getCredentials();
                ctx.put("javax.xml.ws.security.auth.username", (Object)credentials.getUsername());
                ctx.put("javax.xml.ws.security.auth.password", (Object)credentials.getPassword());
            } else {
                log.debug("Could not find credentials to put in WS-Security header");
            }
        }
        catch (Exception e) {
            log.warn("Error occured when trying to add the credentials to the BindingProvider for WS-Security.", (Throwable)e);
        }
        return true;
    }
}

