/*
 * Decompiled with CFR 0.152.
 */
package org.wsrp.wss.jboss5.handlers.producer;

import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.jboss.web.tomcat.security.login.WebAuthentication;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.invocation.SecurityAdaptor;
import org.jboss.wsf.spi.invocation.SecurityAdaptorFactory;
import org.wsrp.wss.jboss5.handlers.AbstractWSSecurityCredentialHandler;

public class WSSecurityCredentialHandler
extends AbstractWSSecurityCredentialHandler {
    @Override
    protected boolean handleResponse(SOAPMessageContext soapMessageContext) {
        try {
            log.debug("Attempting to add the security Credentials to the current Request");
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            SecurityAdaptor securityAdaptor = ((SecurityAdaptorFactory)spiProvider.getSPI(SecurityAdaptorFactory.class)).newSecurityAdapter();
            if (securityAdaptor != null && securityAdaptor.getPrincipal() != null && securityAdaptor.getPrincipal().getName() != null && securityAdaptor.getCredential() != null) {
                WebAuthentication wa = new WebAuthentication();
                wa.login(securityAdaptor.getPrincipal().getName(), securityAdaptor.getCredential());
            } else {
                log.debug("No securityAdaptor available. Cannot add credentials from the WS Security");
            }
        }
        catch (Exception e) {
            log.warn("Error occured when trying to programatically login using the ws-security credentials.", (Throwable)e);
        }
        return true;
    }
}

