/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDCardinal;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEmpty;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDMixed;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDPCData;
import com.wutka.dtd.DTDParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.AbstractMarshaller;
import org.jboss.xb.binding.AttributesImpl;
import org.jboss.xb.binding.Content;
import org.jboss.xb.binding.ContentWriter;
import org.jboss.xb.binding.DelegatingObjectModelProvider;
import org.jboss.xb.binding.GenericObjectModelProvider;
import org.jboss.xb.binding.ObjectModelProvider;
import org.jboss.xb.binding.TypeBinding;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DtdMarshaller
extends AbstractMarshaller {
    private static final Logger log = Logger.getLogger(DtdMarshaller.class);
    private String publicId;
    private String systemId;
    private final AbstractMarshaller.Stack stack = new AbstractMarshaller.StackImpl();
    private DTD dtd;
    private GenericObjectModelProvider provider;
    private Content content = new Content();
    private final List<Element> elementStack = new ArrayList<Element>();
    private final Map<String, TypeBinding> simpleTypeBindings = new HashMap<String, TypeBinding>();

    public void addBinding(String elementName, TypeBinding binding) {
        this.simpleTypeBindings.put(elementName, binding);
    }

    @Override
    public void mapPublicIdToSystemId(String publicId, String systemId) {
        this.publicId = publicId;
        this.systemId = systemId;
    }

    @Override
    public void declareNamespace(String prefix, String uri) {
        throw new UnsupportedOperationException("declareNamespace is not implemented.");
    }

    @Override
    public void addAttribute(String prefix, String localName, String type, String value) {
        throw new UnsupportedOperationException("addAttribute is not implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(String schemaUri, ObjectModelProvider provider, Object root, Writer writer) throws IOException, ParserConfigurationException, SAXException {
        InputStream is;
        URL url;
        try {
            url = new URL(schemaUri);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed schema URI " + schemaUri + ": " + e.getMessage());
        }
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to open input stream for schema " + schemaUri + ": " + e.getMessage());
        }
        try {
            InputStreamReader reader = new InputStreamReader(is);
            this.marshal(reader, provider, root, writer);
        }
        finally {
            is.close();
        }
    }

    @Override
    public void marshal(Reader dtdReader, ObjectModelProvider provider, Object document, Writer writer) throws IOException, SAXException {
        int i;
        DTDParser parser = new DTDParser(dtdReader);
        this.dtd = parser.parse(true);
        this.provider = provider instanceof GenericObjectModelProvider ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider);
        DTDElement[] roots = null;
        if (this.dtd.rootElement != null) {
            this.handleRootElement(document, this.dtd.rootElement);
        } else {
            roots = DtdMarshaller.getRootList(this.dtd);
            for (i = 0; i < roots.length; ++i) {
                this.handleRootElement(document, roots[i]);
            }
        }
        this.writeXmlVersion(writer);
        writer.write("<!DOCTYPE ");
        if (this.dtd.rootElement != null) {
            writer.write(this.dtd.rootElement.getName());
        } else {
            for (i = 0; i < roots.length; ++i) {
                writer.write(", ");
                writer.write(roots[i].getName());
            }
        }
        writer.write(" PUBLIC \"");
        writer.write(this.publicId);
        writer.write("\" \"");
        writer.write(this.systemId);
        writer.write("\">\n");
        ContentWriter contentWriter = new ContentWriter(writer, this.propertyIsTrueOrNotSet("org.jboss.xml.binding.marshalling.indent"));
        this.content.handleContent(contentWriter);
    }

    private void handleRootElement(Object o, DTDElement dtdRoot) {
        Element el = new Element(dtdRoot, true);
        this.elementStack.add(el);
        this.content.startDocument();
        Object root = this.provider.getRoot(o, null, this.systemId, dtdRoot.getName());
        if (root == null) {
            return;
        }
        this.stack.push(root);
        AttributesImpl attrs = this.provideAttributes(dtdRoot, root);
        this.content.startElement("", dtdRoot.getName(), dtdRoot.getName(), attrs);
        this.handleElement(this.dtd, dtdRoot, attrs);
        this.content.endElement("", dtdRoot.getName(), dtdRoot.getName());
        this.stack.pop();
        this.content.endDocument();
        this.elementStack.remove(this.elementStack.size() - 1);
    }

    private final void handleElement(DTD dtd, DTDElement element, Attributes attrs) {
        DTDItem item = element.content;
        if (item instanceof DTDMixed) {
            this.handleMixedElement(element, attrs);
        } else if (item instanceof DTDEmpty) {
            Object value = this.provider.getElementValue(this.stack.peek(), null, this.systemId, element.getName());
            if (Boolean.TRUE.equals(value)) {
                this.writeSkippedElements();
                this.content.startElement("", element.getName(), element.getName(), attrs);
                this.content.endElement("", element.getName(), element.getName());
            }
        } else if (item instanceof DTDContainer) {
            this.processContainer(dtd, (DTDContainer)item);
        } else {
            throw new IllegalStateException("Unexpected element: " + element.getName());
        }
    }

    private final void handleMixedElement(DTDElement element, Attributes attrs) {
        boolean startElement = false;
        if (!this.elementStack.isEmpty()) {
            Element e = this.elementStack.get(this.elementStack.size() - 1);
            startElement = element != e.element;
        }
        DTDMixed mixed = (DTDMixed)element.content;
        String elementName = element.getName();
        Object parent = this.stack.peek();
        DTDItem[] items = mixed.getItems();
        for (int i = 0; i < items.length; ++i) {
            Object value;
            DTDItem item = items[i];
            if (!(item instanceof DTDPCData) || (value = this.provider.getElementValue(parent, null, this.systemId, elementName)) == null) continue;
            this.writeSkippedElements();
            TypeBinding binding = this.simpleTypeBindings.get(elementName);
            String marshalled = binding != null ? binding.marshal(value) : value.toString();
            char[] ch = marshalled.toCharArray();
            if (startElement) {
                this.content.startElement("", elementName, elementName, attrs);
            }
            this.content.characters(ch, 0, ch.length);
            if (!startElement) continue;
            this.content.endElement("", elementName, elementName);
        }
    }

    private final void handleChildren(DTD dtd, DTDElement element, DTDCardinal elementCardinal) {
        Object parent = this.stack.peek();
        Object children = this.provider.getChildren(parent, null, this.systemId, element.getName());
        if (children != null) {
            boolean singleValued;
            Iterator<Object> iter = children instanceof Iterator ? (Iterator)children : (children instanceof Collection ? ((Collection)children).iterator() : Collections.singletonList(children).iterator());
            this.writeSkippedElements();
            Element el = new Element(element, true);
            this.elementStack.add(el);
            boolean bl = singleValued = elementCardinal == DTDCardinal.NONE || elementCardinal == DTDCardinal.OPTIONAL;
            if (singleValued) {
                this.content.startElement("", element.getName(), element.getName(), null);
            }
            while (iter.hasNext()) {
                AttributesImpl attrs;
                Object child = iter.next();
                this.stack.push(child);
                AttributesImpl attributesImpl = attrs = element.attributes.isEmpty() ? null : this.provideAttributes(element, child);
                if (!singleValued) {
                    this.content.startElement("", element.getName(), element.getName(), attrs);
                }
                this.handleElement(dtd, element, attrs);
                if (!singleValued) {
                    this.content.endElement(this.systemId, element.getName(), element.getName());
                }
                this.stack.pop();
            }
            if (singleValued) {
                this.content.endElement(this.systemId, element.getName(), element.getName());
            }
            this.elementStack.remove(this.elementStack.size() - 1);
        } else {
            boolean removeLast = false;
            if (!(element.getContent() instanceof DTDMixed) && !(element.getContent() instanceof DTDEmpty)) {
                Element el = new Element(element);
                this.elementStack.add(el);
                removeLast = true;
            }
            AttributesImpl attrs = element.attributes.isEmpty() ? null : this.provideAttributes(element, parent);
            this.handleElement(dtd, element, attrs);
            if (removeLast) {
                Element el = this.elementStack.remove(this.elementStack.size() - 1);
                if (el.started) {
                    DTDElement started = el.element;
                    this.content.endElement("", started.getName(), started.getName());
                }
            }
        }
    }

    private final void processContainer(DTD dtd, DTDContainer container) {
        DTDItem[] items = container.getItems();
        for (int i = 0; i < items.length; ++i) {
            DTDItem item = items[i];
            if (item instanceof DTDContainer) {
                this.processContainer(dtd, (DTDContainer)item);
                continue;
            }
            if (!(item instanceof DTDName)) continue;
            DTDName name = (DTDName)item;
            DTDElement element = (DTDElement)dtd.elements.get(name.value);
            this.handleChildren(dtd, element, name.getCardinal());
        }
    }

    private void writeSkippedElements() {
        Element el = this.elementStack.get(this.elementStack.size() - 1);
        if (!el.started) {
            int firstNotStarted = this.elementStack.size() - 1;
            do {
                el = this.elementStack.get(--firstNotStarted);
            } while (!el.started);
            ++firstNotStarted;
            while (firstNotStarted < this.elementStack.size()) {
                el = this.elementStack.get(firstNotStarted++);
                DTDElement notStarted = el.element;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("starting skipped> " + notStarted.getName()));
                }
                this.content.startElement("", notStarted.getName(), notStarted.getName(), null);
                el.started = true;
            }
        }
    }

    private AttributesImpl provideAttributes(DTDElement element, Object container) {
        Hashtable attributes = element.attributes;
        AttributesImpl attrs = new AttributesImpl(attributes.size());
        for (DTDAttribute attr : attributes.values()) {
            Object attrValue = this.provider.getAttributeValue(container, null, this.systemId, attr.getName());
            if (attrValue == null) continue;
            attrs.add(this.systemId, attr.getName(), attr.getName(), attr.getType().toString(), attrValue.toString());
        }
        return attrs;
    }

    protected static DTDElement[] getRootList(DTD dtd) {
        DTDElement element;
        Hashtable<String, DTDElement> roots = new Hashtable<String, DTDElement>();
        Enumeration e = dtd.elements.elements();
        while (e.hasMoreElements()) {
            element = (DTDElement)e.nextElement();
            roots.put(element.name, element);
        }
        e = dtd.elements.elements();
        while (e.hasMoreElements()) {
            element = (DTDElement)e.nextElement();
            if (!(element.content instanceof DTDContainer)) continue;
            Enumeration items = ((DTDContainer)element.content).getItemsVec().elements();
            while (items.hasMoreElements()) {
                DtdMarshaller.removeElements(roots, dtd, (DTDItem)items.nextElement());
            }
        }
        Collection rootCol = roots.values();
        return rootCol.toArray(new DTDElement[rootCol.size()]);
    }

    protected static void removeElements(Hashtable<String, DTDElement> h, DTD dtd, DTDItem item) {
        if (item instanceof DTDName) {
            h.remove(((DTDName)item).value);
        } else if (item instanceof DTDContainer) {
            Enumeration e = ((DTDContainer)item).getItemsVec().elements();
            while (e.hasMoreElements()) {
                DtdMarshaller.removeElements(h, dtd, (DTDItem)e.nextElement());
            }
        }
    }

    private static final class Element {
        public final DTDElement element;
        public boolean started;

        public Element(DTDElement element, boolean started) {
            this.element = element;
            this.started = started;
        }

        public Element(DTDElement element) {
            this.element = element;
        }

        public String toString() {
            return "[element=" + this.element.getName() + ", started=" + this.started + "]";
        }
    }
}

