/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.sunday.unmarshalling.AbstractPosition;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.NonElementPosition;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.xml.sax.Attributes;

public class SequenceBinding
extends ModelGroupBinding {
    private List<ParticleBinding> sequence = Collections.emptyList();
    private ElementBinding arrayItem;

    public SequenceBinding(SchemaBinding schema) {
        super(schema);
    }

    @Override
    public ElementBinding getArrayItem() {
        return this.arrayItem;
    }

    @Override
    public void addParticle(ParticleBinding particle) {
        switch (this.sequence.size()) {
            case 0: {
                this.sequence = Collections.singletonList(particle);
                if (!particle.isRepeatable() || !particle.getTerm().isElement()) break;
                ElementBinding element = (ElementBinding)particle.getTerm();
                if (!particle.isRepeatable()) break;
                this.arrayItem = element;
                break;
            }
            case 1: {
                this.sequence = new ArrayList<ParticleBinding>(this.sequence);
                this.arrayItem = null;
            }
            default: {
                this.sequence.add(particle);
            }
        }
        super.addParticle(particle);
    }

    @Override
    public Collection<ParticleBinding> getParticles() {
        return this.sequence;
    }

    @Override
    public AbstractPosition newPosition(QName qName, Attributes attrs, ParticleBinding seqParticle) {
        for (int i = 0; i < this.sequence.size(); ++i) {
            ParticleBinding particle = this.sequence.get(i);
            AbstractPosition next = particle.getTerm().newPosition(qName, attrs, particle);
            if (next != null) {
                return new SequencePosition(qName, seqParticle, i, next);
            }
            if (!particle.isRequired()) continue;
            return null;
        }
        return null;
    }

    @Override
    public String getGroupType() {
        return "sequence";
    }

    private final class SequencePosition
    extends NonElementPosition {
        private int pos;

        protected SequencePosition(QName qName, ParticleBinding particle, int pos, AbstractPosition next) {
            super(qName, particle, next);
            this.pos = -1;
            this.pos = pos;
        }

        @Override
        public AbstractPosition nextPosition(QName qName, Attributes atts) {
            if (trace) {
                StringBuffer sb = new StringBuffer();
                sb.append("startElement ").append(qName).append(" in ").append(SequenceBinding.this.toString());
                log.trace((Object)sb.toString());
            }
            ++this.pos;
            while (this.pos < SequenceBinding.this.sequence.size()) {
                ParticleBinding particle = (ParticleBinding)SequenceBinding.this.sequence.get(this.pos);
                this.next = particle.getTerm().newPosition(qName, atts, particle);
                if (this.next != null) {
                    this.next.previous = this;
                    return this;
                }
                if (particle.isRequired()) {
                    this.nextNotFound();
                    return null;
                }
                ++this.pos;
            }
            if (this.particle.isOccurrenceAllowed(this.occurrence + 1)) {
                this.pos = 0;
                while (this.pos < SequenceBinding.this.sequence.size()) {
                    ParticleBinding item = (ParticleBinding)SequenceBinding.this.sequence.get(this.pos);
                    TermBinding term = item.getTerm();
                    this.next = term.newPosition(qName, atts, item);
                    if (this.next != null) {
                        this.next.previous = this;
                        ++this.occurrence;
                        if (!this.skip) {
                            this.o = this.handler.endParticle(this.o, qName, this.particle);
                            if (this.previous.o != null) {
                                this.setParent(this.previous, this.handler);
                            }
                            this.initValue(atts);
                        }
                        if (trace) {
                            log.trace((Object)("found " + qName + " in " + SequenceBinding.this));
                        }
                        return this;
                    }
                    if (this.particle.isRequired()) {
                        this.nextNotFound();
                        return null;
                    }
                    ++this.pos;
                }
            }
            if (trace) {
                log.trace((Object)(qName + " not found in " + SequenceBinding.this));
            }
            this.nextNotFound();
            return null;
        }

        @Override
        protected void nextNotFound() {
            super.nextNotFound();
            this.pos = -1;
        }
    }
}

