/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.protocol.stomp.WebSocketServerHandler;
import org.hornetq.core.remoting.impl.netty.HornetQChannelHandler;
import org.hornetq.core.remoting.impl.netty.HornetQFrameDecoder;
import org.hornetq.core.remoting.impl.netty.HornetQFrameDecoder2;
import org.hornetq.core.remoting.impl.netty.HttpAcceptorHandler;
import org.hornetq.core.remoting.impl.netty.HttpKeepAliveRunnable;
import org.hornetq.core.remoting.impl.netty.NettyAcceptorFactory;
import org.hornetq.core.remoting.impl.netty.NettyConnection;
import org.hornetq.core.remoting.impl.netty.TransportConstants;
import org.hornetq.core.remoting.impl.ssl.SSLSupport;
import org.hornetq.core.security.HornetQPrincipal;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.server.management.NotificationService;
import org.hornetq.spi.core.protocol.ProtocolType;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.BufferDecoder;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.utils.ConfigurationHelper;
import org.hornetq.utils.TypedProperties;
import org.hornetq.utils.VersionLoader;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.jboss.netty.channel.StaticChannelPipeline;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.local.DefaultLocalServerChannelFactory;
import org.jboss.netty.channel.local.LocalAddress;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.VirtualExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyAcceptor
implements Acceptor {
    static final Logger log = Logger.getLogger(NettyAcceptor.class);
    private ClusterConnection clusterConnection;
    private ChannelFactory channelFactory;
    private volatile ChannelGroup serverChannelGroup;
    private volatile ChannelGroup channelGroup;
    private ServerBootstrap bootstrap;
    private final BufferHandler handler;
    private final BufferDecoder decoder;
    private final ConnectionLifeCycleListener listener;
    private final boolean sslEnabled;
    private final boolean httpEnabled;
    private final long httpServerScanPeriod;
    private final long httpResponseTime;
    private final boolean useNio;
    private final boolean useInvm;
    private final ProtocolType protocol;
    private final String host;
    private final int port;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final boolean tcpNoDelay;
    private final int tcpSendBufferSize;
    private final int tcpReceiveBufferSize;
    private final int nioRemotingThreads;
    private final HttpKeepAliveRunnable httpKeepAliveRunnable;
    private HttpAcceptorHandler httpHandler = null;
    private final ConcurrentMap<Object, NettyConnection> connections = new ConcurrentHashMap<Object, NettyConnection>();
    private final Map<String, Object> configuration;
    private final Executor threadPool;
    private final ScheduledExecutorService scheduledThreadPool;
    private NotificationService notificationService;
    private VirtualExecutorService bossExecutor;
    private boolean paused;
    private BatchFlusher flusher;
    private ScheduledFuture<?> batchFlusherFuture;
    private final long batchDelay;
    private final boolean directDeliver;

    public NettyAcceptor(Map<String, Object> configuration, BufferHandler handler, BufferDecoder decoder, ConnectionLifeCycleListener listener, Executor threadPool, ScheduledExecutorService scheduledThreadPool) {
        this(null, configuration, handler, decoder, listener, threadPool, scheduledThreadPool);
    }

    public NettyAcceptor(ClusterConnection clusterConnection, Map<String, Object> configuration, BufferHandler handler, BufferDecoder decoder, ConnectionLifeCycleListener listener, Executor threadPool, ScheduledExecutorService scheduledThreadPool) {
        this.clusterConnection = clusterConnection;
        this.configuration = configuration;
        this.handler = handler;
        this.decoder = decoder;
        this.listener = listener;
        this.sslEnabled = ConfigurationHelper.getBooleanProperty("ssl-enabled", false, configuration);
        this.httpEnabled = ConfigurationHelper.getBooleanProperty("http-enabled", false, configuration);
        if (this.httpEnabled) {
            this.httpServerScanPeriod = ConfigurationHelper.getLongProperty("http-server-scan-period", 5000L, configuration);
            this.httpResponseTime = ConfigurationHelper.getLongProperty("http-response-time", 10000L, configuration);
            this.httpKeepAliveRunnable = new HttpKeepAliveRunnable();
            ScheduledFuture<?> future = scheduledThreadPool.scheduleAtFixedRate(this.httpKeepAliveRunnable, this.httpServerScanPeriod, this.httpServerScanPeriod, TimeUnit.MILLISECONDS);
            this.httpKeepAliveRunnable.setFuture(future);
        } else {
            this.httpServerScanPeriod = 0L;
            this.httpResponseTime = 0L;
            this.httpKeepAliveRunnable = null;
        }
        this.useNio = ConfigurationHelper.getBooleanProperty("use-nio", false, configuration);
        this.nioRemotingThreads = ConfigurationHelper.getIntProperty("nio-remoting-threads", -1, configuration);
        this.useInvm = ConfigurationHelper.getBooleanProperty("use-invm", false, configuration);
        String protocolStr = ConfigurationHelper.getStringProperty("protocol", TransportConstants.DEFAULT_PROTOCOL, configuration);
        this.protocol = ProtocolType.valueOf(protocolStr.toUpperCase());
        this.host = ConfigurationHelper.getStringProperty("host", "localhost", configuration);
        this.port = ConfigurationHelper.getIntProperty("port", 5445, configuration);
        if (this.sslEnabled) {
            this.keyStorePath = ConfigurationHelper.getStringProperty("key-store-path", "hornetq.keystore", configuration);
            this.keyStorePassword = ConfigurationHelper.getPasswordProperty("key-store-password", "secureexample", configuration);
            this.trustStorePath = ConfigurationHelper.getStringProperty("trust-store-path", "hornetq.truststore", configuration);
            this.trustStorePassword = ConfigurationHelper.getPasswordProperty("trust-store-password", "secureexample", configuration);
        } else {
            this.keyStorePath = null;
            this.keyStorePassword = null;
            this.trustStorePath = null;
            this.trustStorePassword = null;
        }
        this.tcpNoDelay = ConfigurationHelper.getBooleanProperty("tcp-no-delay", true, configuration);
        this.tcpSendBufferSize = ConfigurationHelper.getIntProperty("tcp-send-buffer-size", 32768, configuration);
        this.tcpReceiveBufferSize = ConfigurationHelper.getIntProperty("tcp-receive-buffer-size", 32768, configuration);
        this.threadPool = threadPool;
        this.scheduledThreadPool = scheduledThreadPool;
        this.batchDelay = ConfigurationHelper.getLongProperty("batch-delay", 0L, configuration);
        this.directDeliver = ConfigurationHelper.getBooleanProperty("direct-deliver", true, configuration);
    }

    public synchronized void start() throws Exception {
        SSLContext context;
        if (this.channelFactory != null) {
            return;
        }
        this.bossExecutor = new VirtualExecutorService(this.threadPool);
        VirtualExecutorService workerExecutor = new VirtualExecutorService(this.threadPool);
        if (this.useInvm) {
            this.channelFactory = new DefaultLocalServerChannelFactory();
        } else if (this.useNio) {
            int threadsToUse = this.nioRemotingThreads == -1 ? Runtime.getRuntime().availableProcessors() * 3 : this.nioRemotingThreads;
            this.channelFactory = new NioServerSocketChannelFactory(this.bossExecutor, workerExecutor, threadsToUse);
        } else {
            this.channelFactory = new OioServerSocketChannelFactory(this.bossExecutor, workerExecutor);
        }
        this.bootstrap = new ServerBootstrap(this.channelFactory);
        if (this.sslEnabled) {
            try {
                context = SSLSupport.createServerContext(this.keyStorePath, this.keyStorePassword, this.trustStorePath, this.trustStorePassword);
            }
            catch (Exception e) {
                IllegalStateException ise = new IllegalStateException("Unable to create NettyAcceptor for " + this.host + ":" + this.port);
                ise.initCause(e);
                throw ise;
            }
        } else {
            context = null;
        }
        ChannelPipelineFactory factory = new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline;
                LinkedHashMap<String, ChannelHandler> handlers = new LinkedHashMap<String, ChannelHandler>();
                if (NettyAcceptor.this.sslEnabled) {
                    SSLEngine engine = context.createSSLEngine();
                    engine.setUseClientMode(false);
                    SslHandler handler = new SslHandler(engine);
                    handlers.put("ssl", handler);
                }
                if (NettyAcceptor.this.httpEnabled) {
                    handlers.put("http-decoder", new HttpRequestDecoder());
                    handlers.put("http-aggregator", new HttpChunkAggregator(Integer.MAX_VALUE));
                    handlers.put("http-encoder", new HttpResponseEncoder());
                    NettyAcceptor.this.httpHandler = new HttpAcceptorHandler(NettyAcceptor.this.httpKeepAliveRunnable, NettyAcceptor.this.httpResponseTime);
                    handlers.put("http-handler", NettyAcceptor.this.httpHandler);
                }
                if (NettyAcceptor.this.protocol == ProtocolType.CORE) {
                    handlers.put("hornetq-decoder", new HornetQFrameDecoder2());
                } else if (NettyAcceptor.this.protocol == ProtocolType.STOMP_WS) {
                    handlers.put("http-decoder", new HttpRequestDecoder());
                    handlers.put("http-aggregator", new HttpChunkAggregator(65536));
                    handlers.put("http-encoder", new HttpResponseEncoder());
                    handlers.put("hornetq-decoder", new HornetQFrameDecoder(NettyAcceptor.this.decoder));
                    handlers.put("websocket-handler", (ChannelHandler)new WebSocketServerHandler());
                } else if (NettyAcceptor.this.protocol != ProtocolType.STOMP) {
                    handlers.put("hornetq-decoder", new HornetQFrameDecoder(NettyAcceptor.this.decoder));
                }
                handlers.put("handler", new HornetQServerChannelHandler(NettyAcceptor.this.channelGroup, NettyAcceptor.this.handler, new Listener()));
                if (NettyAcceptor.this.protocol == ProtocolType.STOMP_WS) {
                    pipeline = new DefaultChannelPipeline();
                    for (Map.Entry handler : handlers.entrySet()) {
                        pipeline.addLast((String)handler.getKey(), (ChannelHandler)handler.getValue());
                    }
                } else {
                    pipeline = new StaticChannelPipeline(handlers.values().toArray(new ChannelHandler[handlers.size()]));
                }
                return pipeline;
            }
        };
        this.bootstrap.setPipelineFactory(factory);
        this.bootstrap.setOption("child.tcpNoDelay", this.tcpNoDelay);
        if (this.tcpReceiveBufferSize != -1) {
            this.bootstrap.setOption("child.receiveBufferSize", this.tcpReceiveBufferSize);
        }
        if (this.tcpSendBufferSize != -1) {
            this.bootstrap.setOption("child.sendBufferSize", this.tcpSendBufferSize);
        }
        this.bootstrap.setOption("reuseAddress", true);
        this.bootstrap.setOption("child.reuseAddress", true);
        this.bootstrap.setOption("child.keepAlive", true);
        this.channelGroup = new DefaultChannelGroup("hornetq-accepted-channels");
        this.serverChannelGroup = new DefaultChannelGroup("hornetq-acceptor-channels");
        this.startServerChannels();
        this.paused = false;
        if (!"3.2.6.Final-redhat-2-20df069".equals(VersionLoader.getVersion().getNettyVersion())) {
            log.warn("Unexpected Netty Version was expecting " + VersionLoader.getVersion().getNettyVersion() + " using " + "3.2.6.Final-redhat-2-20df069");
        }
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("factory"), new SimpleString(NettyAcceptorFactory.class.getName()));
            props.putSimpleStringProperty(new SimpleString("host"), new SimpleString(this.host));
            props.putIntProperty(new SimpleString("port"), this.port);
            Notification notification = new Notification(null, NotificationType.ACCEPTOR_STARTED, props);
            this.notificationService.sendNotification(notification);
        }
        if (this.batchDelay > 0L) {
            this.flusher = new BatchFlusher();
            this.batchFlusherFuture = this.scheduledThreadPool.scheduleWithFixedDelay(this.flusher, this.batchDelay, this.batchDelay, TimeUnit.MILLISECONDS);
        }
        log.info("Started Netty Acceptor version 3.2.6.Final-redhat-2-20df069 " + this.host + ":" + this.port + " for " + (Object)((Object)this.protocol) + " protocol");
    }

    private void startServerChannels() {
        String[] hosts;
        for (String h : hosts = TransportConfiguration.splitHosts(this.host)) {
            SocketAddress address = this.useInvm ? new LocalAddress(h) : new InetSocketAddress(h, this.port);
            Channel serverChannel = this.bootstrap.bind(address);
            this.serverChannelGroup.add(serverChannel);
        }
    }

    @Override
    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public synchronized void stop() {
        if (this.channelFactory == null) {
            return;
        }
        if (this.batchFlusherFuture != null) {
            this.batchFlusherFuture.cancel(false);
            this.flusher.cancel();
            this.flusher = null;
            this.batchFlusherFuture = null;
        }
        this.serverChannelGroup.close().awaitUninterruptibly();
        if (this.httpKeepAliveRunnable != null) {
            this.httpKeepAliveRunnable.close();
        }
        this.serverChannelGroup.close().awaitUninterruptibly();
        ChannelGroupFuture future = this.channelGroup.close().awaitUninterruptibly();
        if (!future.isCompleteSuccess()) {
            log.warn("channel group did not completely close");
            for (Channel channel : future.getGroup()) {
                if (!channel.isBound()) continue;
                log.warn(channel + " is still connected to " + channel.getRemoteAddress());
            }
        }
        this.channelFactory.releaseExternalResources();
        this.channelFactory = null;
        for (NettyConnection connection : this.connections.values()) {
            this.listener.connectionDestroyed(connection.getID());
        }
        this.connections.clear();
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("factory"), new SimpleString(NettyAcceptorFactory.class.getName()));
            props.putSimpleStringProperty(new SimpleString("host"), new SimpleString(this.host));
            props.putIntProperty(new SimpleString("port"), this.port);
            Notification notification = new Notification(null, NotificationType.ACCEPTOR_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.httpHandler != null) {
            this.httpHandler.shutdown();
        }
        this.paused = false;
    }

    public boolean isStarted() {
        return this.channelFactory != null;
    }

    @Override
    public void pause() {
        if (this.paused) {
            return;
        }
        if (this.channelFactory == null) {
            return;
        }
        ChannelGroupFuture future = this.serverChannelGroup.unbind().awaitUninterruptibly();
        if (!future.isCompleteSuccess()) {
            log.warn("server channel group did not completely unbind");
            for (Channel channel : future.getGroup()) {
                if (!channel.isBound()) continue;
                log.warn(channel + " is still bound to " + channel.getRemoteAddress());
            }
        }
        this.bossExecutor.shutdown();
        try {
            this.bossExecutor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.paused = true;
    }

    @Override
    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @Override
    public void setDefaultHornetQPrincipal(HornetQPrincipal defaultHornetQPrincipal) {
        throw new IllegalStateException("unsecure connections not allowed");
    }

    @Override
    public boolean isUnsecurable() {
        return false;
    }

    @Override
    public ClusterConnection getClusterConnection() {
        return this.clusterConnection;
    }

    private class BatchFlusher
    implements Runnable {
        private boolean cancelled;

        private BatchFlusher() {
        }

        public synchronized void run() {
            if (!this.cancelled) {
                for (NettyConnection connection : NettyAcceptor.this.connections.values()) {
                    connection.checkFlushBatchBuffer();
                }
            }
        }

        public synchronized void cancel() {
            this.cancelled = true;
        }
    }

    private class Listener
    implements ConnectionLifeCycleListener {
        private Listener() {
        }

        public void connectionCreated(Acceptor acceptor, Connection connection, ProtocolType protocol) {
            if (NettyAcceptor.this.connections.putIfAbsent(connection.getID(), (NettyConnection)connection) != null) {
                throw new IllegalArgumentException("Connection already exists with id " + connection.getID());
            }
            NettyAcceptor.this.listener.connectionCreated(acceptor, connection, NettyAcceptor.this.protocol);
        }

        public void connectionDestroyed(Object connectionID) {
            if (NettyAcceptor.this.connections.remove(connectionID) != null) {
                NettyAcceptor.this.listener.connectionDestroyed(connectionID);
            }
        }

        public void connectionException(final Object connectionID, final HornetQException me) {
            new Thread(){

                public void run() {
                    NettyAcceptor.this.listener.connectionException(connectionID, me);
                }
            }.start();
        }

        public void connectionReadyForWrites(Object connectionID, boolean ready) {
            NettyConnection conn = (NettyConnection)NettyAcceptor.this.connections.get(connectionID);
            if (conn != null) {
                conn.fireReady(ready);
            }
        }
    }

    private final class HornetQServerChannelHandler
    extends HornetQChannelHandler {
        HornetQServerChannelHandler(ChannelGroup group, BufferHandler handler, ConnectionLifeCycleListener listener) {
            super(group, handler, listener);
        }

        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            new NettyConnection(NettyAcceptor.this.configuration, NettyAcceptor.this, e.getChannel(), new Listener(), !NettyAcceptor.this.httpEnabled && NettyAcceptor.this.batchDelay > 0L, NettyAcceptor.this.directDeliver);
            SslHandler sslHandler = ctx.getPipeline().get(SslHandler.class);
            if (sslHandler != null) {
                sslHandler.handshake().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            HornetQServerChannelHandler.this.active = true;
                        } else {
                            future.getChannel().close();
                        }
                    }
                });
            } else {
                this.active = true;
            }
        }
    }
}

