/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.naming.ejb;

import java.util.Hashtable;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBHomeLocator;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.ejb.client.naming.ejb.EjbJndiIdentifier;
import org.jboss.ejb.client.naming.ejb.EjbJndiNameParser;
import org.jboss.ejb.client.naming.ejb.SecurityActions;
import org.jboss.logging.Logger;

class EjbNamingContext
implements Context {
    private static final Logger log = Logger.getLogger("org.jboss.ejb.client.naming");
    public static final EjbNamingContext ROOT = new EjbNamingContext();
    private final Hashtable<String, Object> environment = new Hashtable();
    private final boolean root;
    private final String application;
    private final String module;
    private final String distinct;

    protected EjbNamingContext(String application, String module, String distinct) {
        this.application = application;
        this.module = module;
        this.distinct = distinct;
        this.root = false;
    }

    protected EjbNamingContext() {
        this.application = null;
        this.module = null;
        this.distinct = null;
        this.root = true;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public Object lookup(String name) throws NamingException {
        EjbJndiIdentifier identifier = this.root ? EjbJndiNameParser.parse(name) : (this.application == null || this.application.isEmpty() ? EjbJndiNameParser.parse("ejb:" + name) : (this.module == null || this.module.isEmpty() ? EjbJndiNameParser.parse(this.application, name) : (this.distinct == null || this.distinct.isEmpty() ? EjbJndiNameParser.parse(this.application, this.module, name) : EjbJndiNameParser.parse(this.application, this.module, this.distinct, name))));
        if (identifier.getEjbName() == null) {
            return this.createEjbContext(identifier);
        }
        return this.createEjbProxy(identifier);
    }

    private Object createEjbContext(EjbJndiIdentifier identifier) {
        return new EjbNamingContext(identifier.getApplication(), identifier.getModule(), identifier.getDistinctName());
    }

    protected Object createEjbProxy(EjbJndiIdentifier identifier) throws NamingException {
        Class<?> viewClass;
        try {
            viewClass = Class.forName(identifier.getViewName(), false, SecurityActions.getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            NamingException naming = Logs.MAIN.couldNotLoadProxyClass(identifier.getViewName());
            naming.setRootCause(e);
            throw naming;
        }
        try {
            return EJBHome.class.isAssignableFrom(viewClass) ? this.doCreateHomeProxy(viewClass.asSubclass(EJBHome.class), identifier) : this.doCreateProxy(viewClass, identifier);
        }
        catch (Exception e) {
            NamingException ne = new NamingException("Failed to create proxy");
            ne.initCause(e);
            throw ne;
        }
    }

    private <T extends EJBHome> T doCreateHomeProxy(Class<T> viewClass, EjbJndiIdentifier identifier) throws Exception {
        boolean stateful;
        Map<String, String> options = identifier.getOptions();
        boolean bl = stateful = options.containsKey("stateful") && !"false".equalsIgnoreCase(options.get("stateful"));
        if (stateful) {
            log.warnf("Ignoring 'stateful' option on lookup of home %s", (Object)viewClass);
        }
        EJBHomeLocator<T> locator = new EJBHomeLocator<T>(viewClass, identifier.getApplication(), identifier.getModule(), identifier.getEjbName(), identifier.getDistinctName());
        return (T)((EJBHome)EJBClient.createProxy(locator));
    }

    private <T> T doCreateProxy(Class<T> viewClass, EjbJndiIdentifier identifier) throws Exception {
        Map<String, String> options = identifier.getOptions();
        boolean stateful = options.containsKey("stateful") && !"false".equalsIgnoreCase(options.get("stateful"));
        EJBLocator locator = stateful ? EJBClient.createSession(viewClass, identifier.getApplication(), identifier.getModule(), identifier.getEjbName(), identifier.getDistinctName()) : new StatelessEJBLocator<T>(viewClass, identifier.getApplication(), identifier.getModule(), identifier.getEjbName(), identifier.getDistinctName());
        return EJBClient.createProxy(locator);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public void unbind(String name) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperation();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperation();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperation();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperation();
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return new NameParser(){

            @Override
            public Name parse(String name) throws NamingException {
                return new CompositeName(name);
            }
        };
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return new NameParser(){

            @Override
            public Name parse(String name) throws NamingException {
                return new CompositeName(name);
            }
        };
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(new CompositeName(name), new CompositeName(prefix)).toString();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        Object existing = this.environment.get(propName);
        this.environment.put(propName, propVal);
        return existing;
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.environment.remove(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.environment;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        if (this.application == null) {
            return "ejb:";
        }
        if (this.module == null) {
            return "ejb:" + this.application;
        }
        if (this.distinct == null) {
            return "ejb:" + this.application + "/" + this.module;
        }
        return "ejb:" + this.application + "/" + this.module + "/" + this.distinct;
    }
}

